/*
 * Decompiled with CFR 0.152.
 */
package me.hekr.iotos.softgateway.sample;

import io.netty.handler.codec.mqtt.MqttQoS;
import io.vertx.mqtt.MqttTopicSubscription;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import me.hekr.iotos.softgateway.network.mqtt.ConnectionContext;
import me.hekr.iotos.softgateway.network.mqtt.MqttServer;
import me.hekr.iotos.softgateway.network.mqtt.PacketCoder;
import me.hekr.iotos.softgateway.network.mqtt.listener.AcceptAllConnectionListenerAdapter;
import me.hekr.iotos.softgateway.network.mqtt.listener.Listener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttServerSample {
    private static final Logger log = LoggerFactory.getLogger(MqttServerSample.class);

    public static void main(String[] args) {
        try {
            MqttServer mqttServer = new MqttServer();
            mqttServer.setPacketCoder(PacketCoder.STRING_CODER);
            mqttServer.setListener((Listener)new AcceptAllConnectionListenerAdapter<String>(){

                public boolean aclPubTopic(ConnectionContext<String> context, String topic, MqttQoS qoS) {
                    if (topic.startsWith("admin")) {
                        return "admin".equals(context.getUsername());
                    }
                    return true;
                }

                public List<MqttQoS> aclSubTopic(ConnectionContext<String> context, List<MqttTopicSubscription> topicSubscriptions) {
                    return topicSubscriptions.stream().map(t -> {
                        if (t.topicName().startsWith("admin")) {
                            boolean allow = "admin".equals(context.getUsername());
                            return allow ? t.qualityOfService() : MqttQoS.FAILURE;
                        }
                        return t.qualityOfService();
                    }).collect(Collectors.toList());
                }
            });
            mqttServer.start();
            new CountDownLatch(1).await();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

