/*
 * Decompiled with CFR 0.152.
 */
package me.hekr.iotos.softgateway.common.utils;

import cn.hutool.core.thread.ThreadFactoryBuilder;
import java.io.Closeable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadPoolUtil
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(ThreadPoolUtil.class);
    public static final Thread.UncaughtExceptionHandler DEFAULT_UNCAUGHT_EXCEPTION_HANDLER = (t, e) -> log.error("[thread:" + t.getName() + "] priority:" + t.getPriority() + ", " + e.getMessage(), e);
    private static final int CORES = Runtime.getRuntime().availableProcessors();
    private static final ConcurrentHashMap<String, ThreadPoolExecutor> THREAD_POOL_EXECUTOR_CONCURRENT_HASH_MAP = new ConcurrentHashMap();
    public static final ScheduledExecutorService DEFAULT_SCHEDULED = (ScheduledExecutorService)((Object)new Builder().setPrefix("spring-schedule").setCore(CORES * 4).setMax(32).setQueueSize(1000).setScheduled(true).build());

    public static ThreadPoolExecutor get(String name) {
        return THREAD_POOL_EXECUTOR_CONCURRENT_HASH_MAP.get(name);
    }

    public static void logAllThreadException(boolean enable) {
        Thread.setDefaultUncaughtExceptionHandler(enable ? DEFAULT_UNCAUGHT_EXCEPTION_HANDLER : null);
    }

    @Override
    public void close() {
        THREAD_POOL_EXECUTOR_CONCURRENT_HASH_MAP.values().forEach(ThreadPoolExecutor::shutdown);
    }

    static {
        StringBuilder message = new StringBuilder();
        ScheduledThreadPoolExecutor timerExecutor = (ScheduledThreadPoolExecutor)new Builder().setCore(1).setPrefix("thread-pool-util-monitor").setScheduled(true).build();
        timerExecutor.scheduleAtFixedRate(() -> {
            message.delete(0, message.length());
            THREAD_POOL_EXECUTOR_CONCURRENT_HASH_MAP.forEach((k, v) -> message.append((String)k).append(", ").append(v.toString()).append("\n"));
            log.info("\nall thread pools(count: {}) status:\n{}", (Object)THREAD_POOL_EXECUTOR_CONCURRENT_HASH_MAP.size(), (Object)message.toString());
        }, 0L, 1L, TimeUnit.MINUTES);
        log.info("enable all thread exception log");
        Thread.setDefaultUncaughtExceptionHandler(DEFAULT_UNCAUGHT_EXCEPTION_HANDLER);
    }

    public static class SingleThreadPoolExecutor {
        private ThreadPoolExecutor executor;
        private String name;
        private Object lock = new Object();
        private Future future;

        public SingleThreadPoolExecutor(String name) {
            this.name = name;
            this.executor = new Builder().setPrefix(name).setCore(1).setMax(1).setQueueSize(1).setHandler(new ThreadPoolExecutor.DiscardOldestPolicy()).build();
        }

        public synchronized void submit(Runnable runnable) {
            if (this.future != null) {
                this.future.cancel(true);
            }
            this.future = this.executor.submit(runnable);
        }

        public synchronized Future getFuture() {
            return this.future;
        }
    }

    public static class Builder {
        private int dynamicCount;
        private int core = 1;
        private int max = this.core * 2;
        private int queueSize = -1;
        private long keepAliveTime = 0L;
        private TimeUnit timeUnit = TimeUnit.MILLISECONDS;
        private RejectedExecutionHandler handler = new ThreadPoolExecutor.AbortPolicy();
        private String format;
        private Thread.UncaughtExceptionHandler uncaughtExceptionHandler = DEFAULT_UNCAUGHT_EXCEPTION_HANDLER;
        private boolean scheduled;

        public Builder setCore(int core) {
            this.core = core;
            return this;
        }

        public Builder setMax(int max) {
            this.max = max;
            return this;
        }

        public Builder setQueueSize(int queueSize) {
            this.queueSize = queueSize;
            return this;
        }

        public Builder setKeepAliveTime(long keepAliveTime) {
            this.keepAliveTime = keepAliveTime;
            return this;
        }

        public Builder setTimeUnit(TimeUnit timeUnit) {
            this.timeUnit = timeUnit;
            return this;
        }

        public Builder setHandler(RejectedExecutionHandler handler) {
            this.handler = handler;
            return this;
        }

        public Builder setPrefix(String prefix) {
            this.format = prefix + "-%d";
            return this;
        }

        public Builder setCoresDynamic(int dynamic) {
            this.dynamicCount = dynamic;
            return this;
        }

        public Builder setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
            this.uncaughtExceptionHandler = uncaughtExceptionHandler;
            return this;
        }

        public Builder setScheduled(boolean scheduled) {
            this.scheduled = scheduled;
            return this;
        }

        public synchronized ThreadPoolExecutor build() {
            String poolName = StringUtils.defaultString((String)this.format, (String)"sm-default-pool-thread-%s");
            return THREAD_POOL_EXECUTOR_CONCURRENT_HASH_MAP.computeIfAbsent(poolName, name -> {
                ThreadFactoryBuilder threadFactoryBuilder = new ThreadFactoryBuilder().setNamePrefix(poolName);
                if (this.uncaughtExceptionHandler != null) {
                    threadFactoryBuilder.setUncaughtExceptionHandler(this.uncaughtExceptionHandler);
                }
                if (CORES >= this.dynamicCount && this.dynamicCount > 0) {
                    this.core = CORES;
                    this.max = this.core * 2;
                    log.info("thread pool {} use dynamic config, core: {}, max: {}", new Object[]{poolName, this.core, this.max});
                }
                if (this.core < 0) {
                    log.warn("thread pool {} core must be gte 0, will set to cores: {}", (Object)poolName, (Object)CORES);
                    this.core = CORES;
                }
                if (this.max < this.core) {
                    log.warn("thread pool {} max must be gte core, core: {}, max: {}, will set max eq core", new Object[]{poolName, this.core, this.max});
                }
                if (this.scheduled) {
                    return new ScheduledThreadPoolExecutor(this.core, threadFactoryBuilder.build(), this.handler);
                }
                return new ThreadPoolExecutor(this.core, this.max, this.keepAliveTime, this.timeUnit, new LinkedBlockingQueue<Runnable>(this.queueSize == -1 ? this.max * 2 : this.queueSize), threadFactoryBuilder.build(), this.handler);
            });
        }

        public int getDynamicCount() {
            return this.dynamicCount;
        }

        public int getCore() {
            return this.core;
        }

        public int getMax() {
            return this.max;
        }

        public int getQueueSize() {
            return this.queueSize;
        }

        public long getKeepAliveTime() {
            return this.keepAliveTime;
        }

        public TimeUnit getTimeUnit() {
            return this.timeUnit;
        }

        public RejectedExecutionHandler getHandler() {
            return this.handler;
        }

        public String getFormat() {
            return this.format;
        }

        public Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
            return this.uncaughtExceptionHandler;
        }

        public boolean isScheduled() {
            return this.scheduled;
        }
    }
}

