/*
 * Decompiled with CFR 0.152.
 */
package me.hekr.iotos.softgateway.common.utils;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.codec.binary.Base64;

public class JsonUtil {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static JsonNode parse(String str) {
        return (JsonNode)objectMapper.readValue(str, JsonNode.class);
    }

    public static String toJson(Object obj) {
        return objectMapper.writeValueAsString(obj);
    }

    public static byte[] toBytes(Object obj) {
        return objectMapper.writeValueAsBytes(obj);
    }

    public static String toBase64(Object obj) {
        return Base64.encodeBase64String((byte[])objectMapper.writeValueAsBytes(obj));
    }

    public static <T> T fromJson(String payload, Class<T> tClass) {
        return (T)objectMapper.readValue(payload, tClass);
    }

    public static <T> T fromJson(String payload, TypeReference<T> tTypeReference) {
        return (T)objectMapper.readValue(payload, tTypeReference);
    }

    public static <T> T fromBase64(String payload, Class<T> tClass) {
        return (T)objectMapper.readValue(Base64.decodeBase64((String)payload), tClass);
    }

    public static <T> T fromBytes(byte[] payload, Class<T> tClass) {
        return (T)objectMapper.readValue(payload, tClass);
    }

    public static <T> T fromBytes(byte[] payload, TypeReference<T> tTypeReference) {
        return (T)objectMapper.readValue(payload, tTypeReference);
    }

    public static <T> T fromBase64(String payload, TypeReference<T> tTypeReference) {
        return (T)objectMapper.readValue(Base64.decodeBase64((String)payload), tTypeReference);
    }

    public static <T> T convert(Object obj, Class<T> clazz) {
        return (T)objectMapper.convertValue(obj, clazz);
    }

    public static <T> T convert(Object obj, TypeReference<T> tTypeReference) {
        return (T)objectMapper.convertValue(obj, tTypeReference);
    }

    static {
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(DeserializationFeature.FAIL_ON_TRAILING_TOKENS, true);
    }
}

