/*
 * Decompiled with CFR 0.152.
 */
package me.hekr.iotos.softgateway.common.utils;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.thread.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimedCachedBlockingQueue<T> {
    private static final Logger log = LoggerFactory.getLogger(TimedCachedBlockingQueue.class);
    private final int queueSize;
    private final String name;
    private ScheduledExecutorService scheduledExecutorService;
    private final BlockingDeque<Bag<T>> bagQueue;
    private final int batchSize;
    private Bag<T> bag;

    public TimedCachedBlockingQueue(String name, int interval, TimeUnit timeUnit, int batchSize, int queueSize) {
        this.name = name;
        Assert.isTrue((interval > 0 ? 1 : 0) != 0, (String)"interval \u5fc5\u987b\u5927\u4e8e0", (Object[])new Object[0]);
        Assert.notNull((Object)((Object)timeUnit), (String)"timeUnit \u4e0d\u80fd\u4e3anull", (Object[])new Object[0]);
        Assert.isTrue((interval > 0 ? 1 : 0) != 0, (String)"batchSize \u5fc5\u987b\u5927\u4e8e0", (Object[])new Object[0]);
        this.batchSize = batchSize;
        this.queueSize = queueSize;
        this.bagQueue = new LinkedBlockingDeque<Bag<T>>(queueSize);
        this.scheduledExecutorService = new ScheduledThreadPoolExecutor(1, new ThreadFactoryBuilder().setNamePrefix("TimedCachedBlockingQueue-").setDaemon(true).build(), new ThreadPoolExecutor.AbortPolicy());
        this.scheduledExecutorService.scheduleAtFixedRate(() -> {
            try {
                this.checkAndPutBag();
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }, interval, interval, timeUnit);
    }

    private synchronized void checkAndPutBag() {
        boolean offer;
        if (this.bagQueue.size() == this.queueSize) {
            log.warn("TimedCachedBlockingQueue: {}, \u961f\u5217\u6ee1({})\uff0c\u5efa\u8bae\u52a0\u5feb\u6d88\u8d39\u6216\u8005\u52a0\u5927\u961f\u5217\u957f\u5ea6", (Object)this.name, (Object)this.queueSize);
        }
        if (log.isDebugEnabled()) {
            log.debug("name: {} check and put bag into queue, current bag: {} , bag size: {}", new Object[]{this.name, this.bagQueue.size() + 1, this.bag == null ? 0 : this.bag.getSize()});
        }
        if (this.bag != null && (offer = this.bagQueue.offer(this.bag))) {
            this.bag = null;
        }
    }

    public synchronized TimedCachedBlockingQueue put(T t) throws InterruptedException {
        boolean bagOffer;
        boolean isFull;
        if (this.bag == null) {
            this.bag = new Bag(this.batchSize);
        }
        boolean bl = isFull = !(bagOffer = this.bag.offer(t)) || this.bag.isFull();
        if (isFull) {
            this.bagQueue.put(this.bag);
        }
        return this;
    }

    public Bag<T> poll(long timeout, TimeUnit timeUnit) throws InterruptedException {
        Bag<T> tBag = this.bagQueue.poll(timeout, timeUnit);
        return tBag;
    }

    public static class Bag<T> {
        private final ArrayBlockingQueue<T> bagItemQueue;
        private final int capacity;

        public Bag(int capacity) {
            this.bagItemQueue = new ArrayBlockingQueue(capacity);
            this.capacity = capacity;
        }

        public boolean offer(T t) {
            return this.bagItemQueue.offer(t);
        }

        public boolean isFull() {
            return this.bagItemQueue.size() == this.capacity;
        }

        public List<T> getAll() {
            if (this.bagItemQueue.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<T> list = new ArrayList<T>();
            while (!this.bagItemQueue.isEmpty()) {
                list.add(this.bagItemQueue.poll());
            }
            return list;
        }

        public int getSize() {
            return this.bagItemQueue.size();
        }
    }
}

