/*
 * Decompiled with CFR 0.152.
 */
package me.hekr.iotos.softgateway.network.common.client;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.AttributeKey;
import java.net.InetSocketAddress;
import me.hekr.iotos.softgateway.network.common.CloseReason;
import me.hekr.iotos.softgateway.network.common.InternalPacket;
import me.hekr.iotos.softgateway.network.common.PacketContext;
import me.hekr.iotos.softgateway.network.common.client.AbstractClient;
import me.hekr.iotos.softgateway.network.common.client.CommonMessageListener;
import me.hekr.iotos.softgateway.network.common.client.EventListener;
import me.hekr.iotos.softgateway.network.common.listener.MessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class ClientMessageHandler<T>
extends SimpleChannelInboundHandler<InternalPacket<T>> {
    private static final Logger log = LoggerFactory.getLogger(ClientMessageHandler.class);
    private static final AttributeKey<PacketContext<?>> PACKET_CONTEXT = AttributeKey.valueOf((String)"_PACKET_CONTEXT_");
    private final AbstractClient<T> client;
    private final boolean sync;
    private final MessageListener<PacketContext<T>> messageListener;
    private final EventListener<T> eventListener;

    public ClientMessageHandler(AbstractClient<T> client, CommonMessageListener<T> messageListener, EventListener<T> eventListener, boolean sync) {
        this.client = client;
        this.messageListener = messageListener;
        this.eventListener = eventListener;
        this.sync = sync;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void channelRead0(ChannelHandlerContext ctx, InternalPacket<T> packet) {
        if (log.isDebugEnabled()) {
            log.debug("\u6536\u5230\u6d88\u606f\uff1a{}", packet);
        }
        if (!this.sync) {
            this.messageListener.onMessage(PacketContext.wrap(packet.getAddress(), packet.getMessage()));
            return;
        }
        Object object = this.client.LOCK;
        synchronized (object) {
            this.client.result = packet.getMessage();
            this.client.signalAll();
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        log.error("remote:" + ctx.channel().remoteAddress() + ",\u672a\u5904\u7406\u7684\u5f02\u5e38\uff0c" + cause.getMessage(), cause);
    }

    public void channelActive(ChannelHandlerContext ctx) {
        PacketContext packetContext = PacketContext.wrap((InetSocketAddress)ctx.channel().remoteAddress());
        ctx.channel().attr(PACKET_CONTEXT).set(packetContext);
        this.eventListener.onConnect(packetContext);
    }

    private PacketContext<T> getPacketContext(ChannelHandlerContext ctx) {
        return (PacketContext)ctx.channel().attr(PACKET_CONTEXT).get();
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        try {
            PacketContext<T> packetContext = this.getPacketContext(ctx);
            this.eventListener.onDisconnect(packetContext, CloseReason.SERVER_CLOSED);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        ctx.channel().eventLoop().execute(this.client::loopConnect);
    }
}

