/*
 * Decompiled with CFR 0.152.
 */
package me.hekr.iotos.softgateway.network.common.client;

import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.socket.SocketRuntimeException;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.DatagramChannel;
import io.netty.handler.logging.LoggingHandler;
import java.net.InetSocketAddress;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import me.hekr.iotos.softgateway.network.common.InternalPacket;
import me.hekr.iotos.softgateway.network.common.client.ClientMessageHandler;
import me.hekr.iotos.softgateway.network.common.client.CommonMessageListener;
import me.hekr.iotos.softgateway.network.common.client.EventListener;
import me.hekr.iotos.softgateway.network.common.client.EventListenerAdapter;
import me.hekr.iotos.softgateway.network.common.coder.PacketCoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClient<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractClient.class);
    public final Object LOCK = new Object();
    public T result;
    protected boolean enableNetLog;
    protected EventLoopGroup eventLoop;
    protected CommonMessageListener<T> messageListener;
    protected ClientMessageHandler<T> clientMessageHandler;
    protected volatile Channel channel;
    protected int timeout = 2000;
    protected int connectTimeout = 2000;
    protected boolean sync;
    protected int bindPort = 0;
    protected String host;
    protected int port;
    protected Class<? extends Channel> channelClass;
    protected ChannelDuplexHandler packetCoderHandler;
    Bootstrap bootstrap;
    private boolean autoReconnect;
    private EventListener<T> eventListener;

    public AbstractClient(Class<? extends Channel> channelClass) {
        this.channelClass = channelClass;
    }

    public abstract void setPacketCoder(PacketCoder<T> var1);

    protected void init() {
    }

    public void close() {
        log.info("\u51c6\u5907\u5173\u95ed\u670d\u52a1 " + this.getClass().getName());
        try {
            this.preDestroy();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        if (this.eventLoop != null) {
            try {
                log.info("\u5173\u95ed eventLoop");
                this.eventLoop.shutdownGracefully(0L, 10L, TimeUnit.SECONDS);
                log.info(" \u6210\u529f\u5173\u95ed client");
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void preDestroy() {
    }

    public void start() {
        log.info("init");
        this.init();
        log.info("init \u7ed3\u675f");
        log.info((this.sync ? "\u540c\u6b65" : "\u5f02\u6b65") + "\u6a21\u5f0f");
        if (this.sync) {
            if (this.messageListener != null) {
                log.warn("sync \u6a21\u5f0f\u4e0d\u4f1a\u8c03\u7528messageListener");
            }
        } else {
            Objects.requireNonNull(this.messageListener, "async \u6a21\u5f0f\u5fc5\u987b\u8bbe\u7f6emessageListener");
        }
        if (this.eventListener == null) {
            this.eventListener = new EventListenerAdapter();
        }
        this.clientMessageHandler = new ClientMessageHandler<T>(this, this.messageListener, this.eventListener, this.sync);
        this.bootstrap = new Bootstrap();
        this.eventLoop = new NioEventLoopGroup();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)this.bootstrap.group(this.eventLoop)).channel(this.channelClass)).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.connectTimeout)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) {
                if (AbstractClient.this.enableNetLog) {
                    ch.pipeline().addLast(new ChannelHandler[]{new LoggingHandler()});
                }
                ch.pipeline().addLast(new ChannelHandler[]{AbstractClient.this.packetCoderHandler}).addLast(new ChannelHandler[]{AbstractClient.this.clientMessageHandler});
            }
        });
        if (DatagramChannel.class.isAssignableFrom(this.channelClass)) {
            this.channel = this.bootstrap.bind(this.bindPort).awaitUninterruptibly().channel();
        } else {
            this.bootstrap.option(ChannelOption.TCP_NODELAY, (Object)true);
            if (this.autoReconnect) {
                this.loopConnect();
            } else {
                this.connect();
            }
        }
        log.info("start \u6210\u529f");
    }

    public T send(T t) {
        InternalPacket<T> internalPacket = InternalPacket.wrap(t, new InetSocketAddress(this.host, this.port));
        return this.doSend(internalPacket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T doSend(InternalPacket<T> internalPacket) throws InterruptedException, TimeoutException {
        if (log.isDebugEnabled()) {
            log.debug("\u53d1\u9001\u6d88\u606f\uff1a{}", internalPacket);
        }
        if (!this.channel.isActive()) {
            throw new SocketRuntimeException("closed");
        }
        if (this.sync) {
            Object object = this.LOCK;
            synchronized (object) {
                this.result = null;
                this.channel.writeAndFlush(internalPacket).addListener(f -> {
                    if (!f.isSuccess()) {
                        log.error(f.cause().getMessage() + "\uff0c\u6d88\u606f:" + internalPacket.getMessage());
                    }
                });
                this.await(this.timeout);
                if (this.result == null) {
                    throw new TimeoutException("wait response timeout " + this.timeout + "ms");
                }
                return this.result;
            }
        }
        this.channel.writeAndFlush(internalPacket).addListener(f -> {
            if (!f.isSuccess()) {
                log.error(f.cause().getMessage() + "\uff0c\u6d88\u606f:" + internalPacket.getMessage());
            }
        });
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalAll() {
        Object object = this.LOCK;
        synchronized (object) {
            this.LOCK.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void await(long timeout) throws InterruptedException {
        Object object = this.LOCK;
        synchronized (object) {
            this.LOCK.wait(timeout);
        }
    }

    public void setEventListener(EventListener<T> eventListener) {
        this.eventListener = eventListener;
    }

    protected void loopConnect() {
        if (this.eventLoop.isShuttingDown() || this.eventLoop.isShutdown() || this.eventLoop.isTerminated()) {
            log.error("\u670d\u52a1\u5173\u95ed\uff0c\u4e0d\u80fd\u91cd\u8fde");
            return;
        }
        while (true) {
            try {
                this.connect();
                return;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                ThreadUtil.sleep((long)1000L);
                continue;
            }
            break;
        }
    }

    public boolean isConnected() {
        return this.channel != null && this.channel.isActive();
    }

    protected synchronized void connect() {
        log.info("\u5c1d\u8bd5\u8fde\u63a5\u5230 {}:{}", (Object)this.host, (Object)this.port);
        if (this.isConnected()) {
            log.info("\u5df2\u7ecf\u8fde\u63a5\u6210\u529f");
            return;
        }
        this.channel = this.bootstrap.connect(this.host, this.port).syncUninterruptibly().channel();
        log.info("\u6210\u529f\u8fde\u63a5\u5230 {}:{}", (Object)this.host, (Object)this.port);
    }

    public void setEnableNetLog(boolean enableNetLog) {
        this.enableNetLog = enableNetLog;
    }

    public void setMessageListener(CommonMessageListener<T> messageListener) {
        this.messageListener = messageListener;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setSync(boolean sync) {
        this.sync = sync;
    }

    public int getBindPort() {
        return this.bindPort;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public void setAutoReconnect(boolean autoReconnect) {
        this.autoReconnect = autoReconnect;
    }
}

