/*
 * Decompiled with CFR 0.152.
 */
package me.hekr.iotos.softgateway.network.common;

import io.netty.channel.Channel;
import java.net.InetSocketAddress;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionContext<T> {
    private static final Logger log = LoggerFactory.getLogger(ConnectionContext.class);
    protected final InetSocketAddress address;
    protected Channel channel;
    protected T message;
    protected LocalDateTime lastSendTime;
    protected LocalDateTime lastReceiveTime;

    protected ConnectionContext(InetSocketAddress address, T message) {
        this.address = address;
        this.message = message;
    }

    public static <T> ConnectionContext<T> wrap(InetSocketAddress address) {
        return new ConnectionContext<Object>(address, null);
    }

    public static <T> ConnectionContext<T> wrap(InetSocketAddress address, T message) {
        return new ConnectionContext<T>(address, message);
    }

    public void close() {
        this.channel.close();
    }

    public String toString() {
        return "ConnectionContext(address=" + this.getAddress() + ", channel=" + this.getChannel() + ", message=" + this.getMessage() + ", lastSendTime=" + this.getLastSendTime() + ", lastReceiveTime=" + this.getLastReceiveTime() + ")";
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void setMessage(T message) {
        this.message = message;
    }

    public T getMessage() {
        return this.message;
    }

    public LocalDateTime getLastSendTime() {
        return this.lastSendTime;
    }

    public void setLastSendTime(LocalDateTime lastSendTime) {
        this.lastSendTime = lastSendTime;
    }

    public LocalDateTime getLastReceiveTime() {
        return this.lastReceiveTime;
    }

    public void setLastReceiveTime(LocalDateTime lastReceiveTime) {
        this.lastReceiveTime = lastReceiveTime;
    }
}

