/*
 * Decompiled with CFR 0.152.
 */
package me.hekr.iotos.softgateway.network.common.client;

import java.time.LocalDateTime;
import me.hekr.iotos.softgateway.network.common.CloseReason;
import me.hekr.iotos.softgateway.network.common.ConnectionContext;
import me.hekr.iotos.softgateway.network.common.client.EventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventListenerAdapter<T>
implements EventListener<T> {
    private static final Logger log = LoggerFactory.getLogger(EventListenerAdapter.class);

    @Override
    public void onConnect(ConnectionContext<T> ctx) {
        log.info("onConnect, remote: {}", (Object)ctx.getAddress());
    }

    @Override
    public void onDisconnect(ConnectionContext<T> ctx, CloseReason reason) {
        log.info("onDisconnect, remote: {}, reason: {}", (Object)ctx.getAddress(), (Object)reason);
    }

    @Override
    public void onHeartbeatTimeout(ConnectionContext<T> ctx, LocalDateTime lastOccurTime, int count) {
    }

    @Override
    public void exceptionCaught(ConnectionContext<T> ctx, Throwable t) {
        log.error("exceptionCaught, remote: " + ctx.getAddress() + ", error:" + t.getMessage(), t);
    }
}

