/*
 * Decompiled with CFR 0.152.
 */
package me.hekr.iotos.softgateway.network.http;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import me.hekr.iotos.softgateway.common.utils.JsonUtil;
import me.hekr.iotos.softgateway.network.http.HttpException;
import me.hekr.iotos.softgateway.network.http.HttpPageResponse;
import me.hekr.iotos.softgateway.network.http.HttpRequest;
import me.hekr.iotos.softgateway.network.http.HttpRequestPageable;
import me.hekr.iotos.softgateway.network.http.HttpResponse;
import me.hekr.iotos.softgateway.network.http.HttpResponseChecker;
import me.hekr.iotos.softgateway.network.http.PageableResponse;
import me.hekr.iotos.softgateway.network.http.PageableResponseParser;
import me.hekr.iotos.softgateway.network.http.ResponseParser;
import okhttp3.ConnectionPool;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.logging.HttpLoggingInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClient {
    private static final Logger log = LoggerFactory.getLogger(HttpClient.class);
    private final String baseUrl;
    private OkHttpClient okHttpClient;
    private HttpResponseChecker httpResponseChecker = HttpResponseChecker.DEFAULT;

    private HttpClient(String baseUrl, OkHttpClient client) {
        this.baseUrl = baseUrl;
        this.okHttpClient = client;
    }

    public static HttpClient newInstance(String baseUrl, int timeoutOfSecs, HttpLoggingInterceptor.Level level) {
        ConnectionPool connectionPool = new ConnectionPool(1, 30L, TimeUnit.SECONDS);
        HttpLoggingInterceptor interceptor = new HttpLoggingInterceptor();
        interceptor.setLevel(level);
        OkHttpClient client = new OkHttpClient().newBuilder().readTimeout(Duration.ofSeconds(timeoutOfSecs)).writeTimeout(Duration.ofSeconds(timeoutOfSecs)).callTimeout(Duration.ofSeconds(timeoutOfSecs)).connectionPool(connectionPool).connectTimeout(Duration.ofSeconds(timeoutOfSecs)).retryOnConnectionFailure(false).addInterceptor((Interceptor)interceptor).build();
        return new HttpClient(baseUrl, client);
    }

    public static HttpClient newInstance(String url) {
        return HttpClient.newInstance(url, 3, HttpLoggingInterceptor.Level.BASIC);
    }

    public static HttpClient newInstance(String url, HttpLoggingInterceptor.Level level) {
        return HttpClient.newInstance(url, 3, level);
    }

    public HttpResponse exec(HttpRequest request) {
        HttpResponse httpResponse;
        request.baseUrl = this.baseUrl;
        try {
            Response response = this.okHttpClient.newCall(request.getOkHttpRequest()).execute();
            ResponseBody body = response.body();
            byte[] bytes = body == null ? null : body.bytes();
            httpResponse = new HttpResponse(response, bytes);
        }
        catch (Exception e) {
            throw new HttpException(request, (Throwable)e);
        }
        boolean success = this.httpResponseChecker.isSuccess(httpResponse);
        if (!success) {
            throw new HttpException(request, httpResponse, this.httpResponseChecker.desc());
        }
        return httpResponse;
    }

    public <T> T exec(HttpRequest request, Class<T> clazz) {
        return (T)this.exec(request, (HttpResponse response) -> JsonUtil.fromBytes((byte[])response.bytes, (Class)clazz));
    }

    public <T> T exec(HttpRequest request, ResponseParser<T> parser) {
        HttpResponse response = this.exec(request);
        return parser.parse(response);
    }

    public <R extends PageableResponse<T>, T> List<T> exec(HttpRequestPageable<R> request, PageableResponseParser<R, T> parser, int curPage, int pageSize) {
        ArrayList<T> resultList = new ArrayList<T>();
        boolean hasMore = true;
        int page = curPage;
        while (hasMore) {
            HttpResponse resp = this.exec(request.buildRequest(page, pageSize));
            HttpPageResponse<R, T> parse = parser.parse(resp);
            resultList.addAll(parse.getItems());
            hasMore = request.hasMore(parse.getResult());
            ++page;
        }
        return resultList;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public OkHttpClient getOkHttpClient() {
        return this.okHttpClient;
    }

    public void setHttpResponseChecker(HttpResponseChecker httpResponseChecker) {
        this.httpResponseChecker = httpResponseChecker;
    }
}

