/*
 * Decompiled with CFR 0.152.
 */
package me.hekr.iotos.softgateway.network.http.controller;

import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.json.JSONObject;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import me.hekr.iotos.softgateway.core.config.DeviceRemoteConfig;
import me.hekr.iotos.softgateway.core.dto.CacheDeviceKey;
import me.hekr.iotos.softgateway.core.exception.BizException;
import me.hekr.iotos.softgateway.core.klink.KlinkService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/gateway"})
public class GatewayController {
    @Autowired
    private KlinkService klinkService;

    @GetMapping(value={"/getAllSubDevices"})
    public Set<DeviceRemoteConfig> getAllSubDevices() {
        return DeviceRemoteConfig.getAllSubDevices();
    }

    @GetMapping(value={"/getAllCacheParam"})
    public List<JSONObject> getAllCacheParam() {
        return this.klinkService.getCahceValue().entrySet().stream().map(e -> new JSONObject().set("pk", (Object)((CacheDeviceKey)e.getKey()).getPk()).set("devId", (Object)((CacheDeviceKey)e.getKey()).getDevId()).set("param", (Object)((CacheDeviceKey)e.getKey()).getParam()).set("cmd", (Object)((CacheDeviceKey)e.getKey()).getCmd()).set("value", e.getValue())).collect(Collectors.toList());
    }

    @DeleteMapping(value={"/invalidAllCache"})
    public void invalidAllCache() {
        this.klinkService.invalidAllCache();
    }

    @DeleteMapping(value={"/invalidCache"})
    public void invalidCache(@RequestBody CacheDeviceKey key) {
        GatewayController.checkDeviceExists(key);
        this.klinkService.invalidCache(key);
    }

    private static void checkDeviceExists(CacheDeviceKey key) {
        if (((DeviceRemoteConfig)DeviceRemoteConfig.getByPkAndDevId((String)key.getPk(), (String)key.getDevId()).orElseThrow(() -> new BizException("\u8bbe\u5907\u4e0d\u5b58\u5728"))).isGateway()) {
            throw new BizException("\u4e0d\u80fd\u64cd\u4f5c\u7f51\u5173");
        }
    }

    @DeleteMapping(value={"/invalidCacheByDevice"})
    public void invalidCacheByDevice(@RequestBody CacheDeviceKey key) {
        GatewayController.checkDeviceExists(key);
        this.klinkService.CACHE_PARAM_VALUE.asMap().forEach((cacheKey, value) -> {
            if (cacheKey.getPk().equals(key.getPk()) && cacheKey.getDevId().equals(key.getDevId())) {
                this.klinkService.invalidCache(cacheKey);
            }
        });
    }

    @PutMapping(value={"/deviceSendLoginAll"})
    public void deviceSendLoginAll() {
        for (DeviceRemoteConfig device : DeviceRemoteConfig.getAllSubDevices()) {
            this.klinkService.devLogin(device.getPk(), device.getDevId(), "\u624b\u52a8\u89e6\u53d1");
            ThreadUtil.safeSleep((long)10L);
        }
    }

    @PutMapping(value={"/deviceSendLogin"})
    public void deviceSendLogin(@RequestBody CacheDeviceKey key) {
        GatewayController.checkDeviceExists(key);
        this.klinkService.devLogin(key.getPk(), key.getDevId(), "\u624b\u52a8\u89e6\u53d1");
    }

    @PutMapping(value={"/deviceSendLogoutAll"})
    public void deviceSendLogoutAll() {
        for (DeviceRemoteConfig device : DeviceRemoteConfig.getAllSubDevices()) {
            this.klinkService.devLogout(device.getPk(), device.getDevId(), "\u624b\u52a8\u89e6\u53d1");
            ThreadUtil.safeSleep((long)10L);
        }
    }

    @PutMapping(value={"/deviceSendLogout"})
    public void deviceSendLogout(@RequestBody CacheDeviceKey key) {
        GatewayController.checkDeviceExists(key);
        this.klinkService.devLogout(key.getPk(), key.getDevId(), "\u624b\u52a8\u89e6\u53d1");
    }
}

