/*
 * Decompiled with CFR 0.152.
 */
package me.hekr.iotos.softgateway.network.http.config;

import javax.servlet.http.HttpServletRequest;
import me.hekr.iotos.softgateway.core.dto.AjaxResult;
import me.hekr.iotos.softgateway.core.exception.BizException;
import org.apache.catalina.connector.ClientAbortException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.validation.BindException;
import org.springframework.validation.ObjectError;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.multipart.MaxUploadSizeExceededException;

@RestControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);
    @Autowired
    private Environment env;

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public AjaxResult handleHttpRequestMethodNotSupported(HttpRequestMethodNotSupportedException e, HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        log.error("\u8bf7\u6c42\u5730\u5740'{}',\u4e0d\u652f\u6301'{}'\u8bf7\u6c42", (Object)requestURI, (Object)e.getMethod());
        return AjaxResult.error((int)405, (String)("\u4e0d\u652f\u6301\u8bf7\u6c42\u65b9\u6cd5: " + e.getMethod()));
    }

    @ExceptionHandler(value={Exception.class})
    public AjaxResult handleException(Exception e, HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        log.error("\u8bf7\u6c42\u5730\u5740':" + requestURI + " ,\u53d1\u751f\u7cfb\u7edf\u5f02\u5e38. " + e.getMessage(), (Throwable)e);
        return AjaxResult.error((int)500, (String)"\u7cfb\u7edf\u9519\u8bef");
    }

    @ExceptionHandler(value={BizException.class})
    public AjaxResult handleException(BizException e, HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        log.warn("\u8bf7\u6c42\u5730\u5740':" + requestURI + " ,\u4e1a\u52a1\u5f02\u5e38. " + e.getMessage(), (Throwable)e);
        return AjaxResult.error((int)400, (String)e.getMessage());
    }

    @ExceptionHandler(value={BindException.class})
    public AjaxResult handleBindException(BindException e) {
        log.warn(e.getMessage(), (Throwable)e);
        String message = ((ObjectError)e.getAllErrors().get(0)).getDefaultMessage();
        return AjaxResult.error((String)message);
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public Object handleMethodArgumentNotValidException(MethodArgumentNotValidException e) {
        log.error(e.getMessage(), (Throwable)e);
        String message = e.getBindingResult().getFieldError().getDefaultMessage();
        return AjaxResult.error((String)message);
    }

    @ExceptionHandler(value={ClientAbortException.class})
    public AjaxResult handleClientAbortException(ClientAbortException e, HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        log.warn("\u8bf7\u6c42\u5730\u5740':" + requestURI + " ,\u5ba2\u6237\u7aef\u7ec8\u6b62\u8bf7\u6c42. " + e.getMessage(), (Throwable)e);
        return AjaxResult.error((String)"\u5ba2\u6237\u7aef\u7ec8\u6b62\u8bf7\u6c42");
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    public AjaxResult handleMissingServletRequestParameterException(MissingServletRequestParameterException e, HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        log.warn("\u8bf7\u6c42\u5730\u5740':" + requestURI + " ,\u53c2\u6570\u7ed1\u5b9a\u9519\u8bef. " + e.getMessage(), (Throwable)e);
        return AjaxResult.error((String)("\u53c2\u6570\u9519\u8bef\uff1a" + e.getParameterName() + " \u7c7b\u578b\uff1a" + e.getParameterType()));
    }

    @ExceptionHandler(value={MaxUploadSizeExceededException.class})
    public AjaxResult handleMaxUploadSizeExceededException(MaxUploadSizeExceededException e, HttpServletRequest request) {
        String limit = this.env.getProperty("spring.servlet.multipart.max-file-size");
        String requestURI = request.getRequestURI();
        log.warn("\u8bf7\u6c42\u5730\u5740':" + requestURI + " ,\u4e0a\u4f20\u6587\u4ef6\u8d85\u8fc7\u9650\u5236  " + limit + " ," + e.getMessage(), (Throwable)e);
        return AjaxResult.error((String)("\u4e0a\u4f20\u6587\u4ef6\u8d85\u8fc7\u9650\u5236 " + limit));
    }
}

