/*
 * Decompiled with CFR 0.152.
 */
package me.hekr.iotos.softgateway.network.http;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import me.hekr.iotos.softgateway.network.http.HttpMethod;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.springframework.http.MediaType;

public class HttpRequest {
    protected Request request;
    String baseUrl;
    private boolean init;
    private Builder requestBuilder;

    public HttpRequest(Builder builder) {
        this.requestBuilder = builder;
    }

    public HttpRequest(Request request) {
        this.request = request;
    }

    public static Builder builder() {
        return new Builder();
    }

    Request buildRequest() {
        HttpUrl httpUrl = HttpUrl.parse((String)this.requestBuilder.path);
        if (httpUrl == null) {
            httpUrl = HttpUrl.parse((String)(this.baseUrl + this.requestBuilder.path));
            Objects.requireNonNull(httpUrl, "\u9700\u8981\u586b\u5199baseUrl \u6216\u8005 request \u7684 path \u9700\u8981\u586b\u5199\u5b8c\u6574\u7684 url \u5730\u5740");
        }
        HttpUrl.Builder httpUrlBuilder = httpUrl.newBuilder();
        this.requestBuilder.queryParams.forEach((k, v) -> httpUrlBuilder.addQueryParameter(k, String.valueOf(v)));
        return this.requestBuilder.okHttpRequestBuilder.url(httpUrlBuilder.build()).build();
    }

    public Request getOkHttpRequest() {
        if (this.request != null) {
            return this.request;
        }
        this.request = this.buildRequest();
        return this.request;
    }

    public String toString() {
        return "HttpRequest{request=" + this.getOkHttpRequest() + '}';
    }

    public static class Builder {
        private final Map<String, Object> queryParams = new HashMap<String, Object>(10);
        private final Headers.Builder headerBuilder = new Headers.Builder();
        Request.Builder okHttpRequestBuilder;
        private byte[] body;
        private HttpMethod method = HttpMethod.GET;
        private MediaType mediaType = MediaType.APPLICATION_JSON;
        private String path = "";

        public HttpRequest build() {
            this.okHttpRequestBuilder = new Request.Builder();
            this.handleHeaders();
            this.handleMethodAndBody();
            return new HttpRequest(this);
        }

        private void handleUrl() {
            HttpUrl.Builder httpUrlBuilder = HttpUrl.get((String)this.path).newBuilder();
            this.queryParams.forEach((k, v) -> httpUrlBuilder.addQueryParameter(k, String.valueOf(v)));
            this.okHttpRequestBuilder.url(httpUrlBuilder.build());
        }

        private void handleMethodAndBody() {
            RequestBody requestBody = null;
            if (okhttp3.internal.http.HttpMethod.requiresRequestBody((String)this.method.name())) {
                if (this.body == null) {
                    this.body = new byte[0];
                }
                requestBody = RequestBody.create((okhttp3.MediaType)okhttp3.MediaType.parse((String)this.mediaType.toString()), (byte[])this.body);
            }
            this.okHttpRequestBuilder.method(this.method.name(), requestBody);
        }

        private void handleHeaders() {
            this.okHttpRequestBuilder.headers(this.headerBuilder.build());
        }

        public Builder addHeader(String name, String value) {
            this.headerBuilder.add(name, value);
            return this;
        }

        public Builder body(byte[] body) {
            this.body = body;
            return this;
        }

        public Builder addParam(String name, Object value) {
            this.queryParams.put(name, value);
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder method(HttpMethod method) {
            this.method = method;
            return this;
        }

        public Builder mediaType(MediaType mediaType) {
            this.mediaType = mediaType;
            return this;
        }
    }
}

