/*
 * Decompiled with CFR 0.152.
 */
package me.hekr.iotos.softgateway.network.http;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PageUtil<T>
implements Serializable {
    private static final long serialVersionUID = 5926676981594352187L;
    private long totalElements;
    private int page;
    private int size;
    private List<T> content;

    public static <T> PageUtil<T> of(int page, int size) {
        PageUtil<T> pagec = new PageUtil<T>();
        pagec.page = page;
        pagec.size = size;
        return pagec;
    }

    public static <T> List<T> getAll(int initPage, int pageSize, PageCall<T> request) {
        ArrayList<T> result = new ArrayList<T>();
        int i = initPage;
        while (true) {
            List<T> list = request.onPage(i, pageSize);
            result.addAll(list);
            if (list.size() < pageSize) break;
            ++i;
        }
        return result;
    }

    public static <T> void onPage(int initPage, int pageSize, PageCall<T> request) {
        List<T> list;
        int i = initPage;
        while ((list = request.onPage(i, pageSize)).size() >= pageSize) {
            ++i;
        }
    }

    public int getTotalPages() {
        return this.size == 0 ? 1 : (int)Math.ceil((double)this.totalElements / (double)this.size);
    }

    public List<T> getContent() {
        return this.content == null ? Collections.emptyList() : this.content;
    }

    public long getTotalElements() {
        return this.totalElements;
    }

    public int getPage() {
        return this.page;
    }

    public int getSize() {
        return this.size;
    }

    public void setTotalElements(long totalElements) {
        this.totalElements = totalElements;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setContent(List<T> content) {
        this.content = content;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageUtil)) {
            return false;
        }
        PageUtil other = (PageUtil)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTotalElements() != other.getTotalElements()) {
            return false;
        }
        if (this.getPage() != other.getPage()) {
            return false;
        }
        if (this.getSize() != other.getSize()) {
            return false;
        }
        List<T> this$content = this.getContent();
        List<T> other$content = other.getContent();
        return !(this$content == null ? other$content != null : !((Object)this$content).equals(other$content));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PageUtil;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $totalElements = this.getTotalElements();
        result = result * 59 + (int)($totalElements >>> 32 ^ $totalElements);
        result = result * 59 + this.getPage();
        result = result * 59 + this.getSize();
        List<T> $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : ((Object)$content).hashCode());
        return result;
    }

    public String toString() {
        return "PageUtil(totalElements=" + this.getTotalElements() + ", page=" + this.getPage() + ", size=" + this.getSize() + ", content=" + this.getContent() + ")";
    }

    public static interface PageCall<T> {
        public List<T> onPage(int var1, int var2);
    }
}

