/*
 * Decompiled with CFR 0.152.
 */
package me.hekr.iotos.softgateway.network.mqtt.listener;

import io.netty.handler.codec.mqtt.MqttQoS;
import io.vertx.mqtt.MqttTopicSubscription;
import java.util.List;
import java.util.stream.Collectors;
import me.hekr.iotos.softgateway.network.mqtt.ConnectionContext;
import me.hekr.iotos.softgateway.network.mqtt.listener.Listener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractListenerAdapter<T>
implements Listener<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractListenerAdapter.class);

    @Override
    public void onConnect(ConnectionContext<T> context) {
        log.info("\u5efa\u7acb\u8fde\u63a5\uff0cclientid:{}, address:{}", (Object)context.getClientId(), (Object)context.getAddress());
    }

    @Override
    public void onDisconnect(ConnectionContext<T> context) {
        log.info("\u65ad\u5f00\u8fde\u63a5\uff0cclientId:{}", (Object)context.getClientId());
    }

    @Override
    public void onMessage(ConnectionContext<T> context, String topic, MqttQoS qos, T payload) {
        log.info("\u6536\u5230\u6d88\u606f\uff0cclientId:{},topic:{},qos:{},message:{}", new Object[]{context.getClientId(), topic, qos, payload});
        context.publish(topic + "/resp", payload);
    }

    @Override
    public void onClose(ConnectionContext<T> context) {
        log.info("\u5173\u95ed\u8fde\u63a5\uff0cclientId:{}", (Object)context.getClientId());
    }

    @Override
    public boolean aclPubTopic(ConnectionContext<T> context, String topic, MqttQoS qoS) {
        if (log.isDebugEnabled()) {
            log.debug("publish acl\uff0cclientId:{}", (Object)context.getClientId());
        }
        return true;
    }

    @Override
    public List<MqttQoS> aclSubTopic(ConnectionContext<T> context, List<MqttTopicSubscription> topicSubscriptions) {
        return topicSubscriptions.stream().map(MqttTopicSubscription::qualityOfService).collect(Collectors.toList());
    }
}

