/*
 * Decompiled with CFR 0.152.
 */
package me.hekr.iotos.softgateway.network.mqtt;

import io.netty.handler.codec.mqtt.MqttQoS;
import io.vertx.core.buffer.Buffer;
import io.vertx.mqtt.MqttEndpoint;
import java.net.InetSocketAddress;
import java.time.LocalDateTime;
import me.hekr.iotos.softgateway.network.mqtt.PacketCoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionContext<T> {
    private static final Logger log = LoggerFactory.getLogger(ConnectionContext.class);
    MqttEndpoint endpoint;
    private PacketCoder<T> packetCoder;
    private String clientId;
    private String username;
    private String password;
    private InetSocketAddress address;
    private LocalDateTime connectTime;
    private LocalDateTime authTime;
    private boolean auth;

    public void publish(String topic, T payload) {
        this.publish(topic, MqttQoS.AT_MOST_ONCE, payload);
    }

    public void publish(String topic, MqttQoS qos, T payload) {
        this.endpoint.publish(topic, Buffer.buffer((byte[])this.packetCoder.encode(payload)), qos, false, false).onComplete(ar -> {
            if (ar.succeeded() && log.isDebugEnabled()) {
                log.debug("\u53d1\u9001\u6d88\u606f\u6210\u529f, topic\uff1a{}\uff0c qos: {} , payload: {}", new Object[]{topic, qos, payload});
            } else {
                log.error("\u53d1\u9001\u6d88\u606f\u5931\u8d25, topic\uff1a{}\uff0c qos: {} , payload: {} , error: {}", new Object[]{topic, qos, payload, ar.cause().getMessage()});
            }
        });
    }

    public void setPacketCoder(PacketCoder<T> packetCoder) {
        this.packetCoder = packetCoder;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setAddress(InetSocketAddress address) {
        this.address = address;
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public void setConnectTime(LocalDateTime connectTime) {
        this.connectTime = connectTime;
    }

    public LocalDateTime getConnectTime() {
        return this.connectTime;
    }

    public void setAuthTime(LocalDateTime authTime) {
        this.authTime = authTime;
    }

    public LocalDateTime getAuthTime() {
        return this.authTime;
    }

    public void setAuth(boolean auth) {
        this.auth = auth;
    }

    public boolean isAuth() {
        return this.auth;
    }
}

