/*
 * Decompiled with CFR 0.152.
 */
package me.hekr.iotos.softgateway.network.tcp;

import io.netty.channel.ChannelHandlerContext;
import java.net.InetSocketAddress;
import java.time.LocalDateTime;
import me.hekr.iotos.softgateway.network.common.CloseReason;
import me.hekr.iotos.softgateway.network.common.PacketContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpServerPacketContext<T>
extends PacketContext<T> {
    private static final Logger log = LoggerFactory.getLogger(TcpServerPacketContext.class);
    protected final ChannelHandlerContext ctx;
    protected CloseReason closeReason;
    protected int heartbeatTimeoutCount = 0;
    protected LocalDateTime occurTime;

    TcpServerPacketContext(ChannelHandlerContext ctx, InetSocketAddress address, T message) {
        super(address, message);
        this.ctx = ctx;
        this.channel = ctx.channel();
    }

    public static <T> PacketContext<T> wrap(ChannelHandlerContext ctx, InetSocketAddress address, T message) {
        return new TcpServerPacketContext<T>(ctx, address, message);
    }

    public static <T> TcpServerPacketContext<T> wrap(ChannelHandlerContext ctx) {
        return new TcpServerPacketContext<Object>(ctx, null, null);
    }

    public static <T> TcpServerPacketContext<T> wrap(ChannelHandlerContext ctx, InetSocketAddress remoteAddress) {
        return new TcpServerPacketContext<Object>(ctx, remoteAddress, null);
    }

    public void resetHeartbeatTimeoutCount() {
        this.heartbeatTimeoutCount = 0;
    }

    public void increaseHeartbeatTimeoutCount() {
        ++this.heartbeatTimeoutCount;
    }

    public CloseReason getCloseReason() {
        return this.closeReason;
    }

    public void setCloseReason(CloseReason closeReason) {
        this.closeReason = closeReason;
    }

    public int getHeartbeatTimeoutCount() {
        return this.heartbeatTimeoutCount;
    }

    public void setHeartbeatTimeoutCount(int heartbeatTimeoutCount) {
        this.heartbeatTimeoutCount = heartbeatTimeoutCount;
    }

    public LocalDateTime getOccurTime() {
        return this.occurTime;
    }

    public void setOccurTime(LocalDateTime occurTime) {
        this.occurTime = occurTime;
    }
}

