/*
 * Decompiled with CFR 0.152.
 */
package me.hekr.iotos.softgateway.network.tcp.listener;

import java.time.LocalDateTime;
import me.hekr.iotos.softgateway.network.common.CloseReason;
import me.hekr.iotos.softgateway.network.tcp.TcpServerPacketContext;
import me.hekr.iotos.softgateway.network.tcp.listener.EventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventListenerAdapter<T>
implements EventListener<T> {
    private static final Logger log = LoggerFactory.getLogger(EventListenerAdapter.class);

    @Override
    public void onConnect(TcpServerPacketContext<T> ctx) {
        log.info("onConnect, remote: {}", (Object)ctx.getAddress());
    }

    @Override
    public void onDisconnect(TcpServerPacketContext<T> ctx, CloseReason reason) {
        log.info("onDisconnect, remote: {}, reason: {}", (Object)ctx.getAddress(), (Object)reason);
    }

    @Override
    public void onHeartbeatTimeout(TcpServerPacketContext<T> ctx, LocalDateTime lastOccurTime, int count) {
        log.warn("onHeartbeatTimeout close connection, remote: {}, lastOccurTime: {}, count: {}", new Object[]{ctx.getAddress(), lastOccurTime, count});
        ctx.setCloseReason(CloseReason.HEARTBEAT_TIMEOUT);
        ctx.close();
    }

    @Override
    public void exceptionCaught(TcpServerPacketContext<T> ctx, Throwable t) {
        log.error("exceptionCaught, remote: " + ctx.getAddress() + ", error:" + t.getMessage(), t);
    }
}

