/*
 * Decompiled with CFR 0.152.
 */
package me.hekr.iotos.softgateway.network.tcp;

import io.netty.channel.ChannelHandlerContext;
import java.net.InetSocketAddress;
import java.time.LocalDateTime;
import me.hekr.iotos.softgateway.network.common.CloseReason;
import me.hekr.iotos.softgateway.network.common.ConnectionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpServerConnectionContext<T>
extends ConnectionContext<T> {
    private static final Logger log = LoggerFactory.getLogger(TcpServerConnectionContext.class);
    protected final ChannelHandlerContext ctx;
    protected CloseReason closeReason;
    protected int heartbeatTimeoutCount = 0;
    protected LocalDateTime occurTime;

    TcpServerConnectionContext(ChannelHandlerContext ctx, InetSocketAddress address, T message) {
        super(address, message);
        this.ctx = ctx;
        this.channel = ctx.channel();
    }

    public static <T> ConnectionContext<T> wrap(ChannelHandlerContext ctx, InetSocketAddress address, T message) {
        return new TcpServerConnectionContext<T>(ctx, address, message);
    }

    public static <T> TcpServerConnectionContext<T> wrap(ChannelHandlerContext ctx) {
        return new TcpServerConnectionContext<Object>(ctx, null, null);
    }

    public static <T> TcpServerConnectionContext<T> wrap(ChannelHandlerContext ctx, InetSocketAddress remoteAddress) {
        return new TcpServerConnectionContext<Object>(ctx, remoteAddress, null);
    }

    public void resetHeartbeatTimeoutCount() {
        this.heartbeatTimeoutCount = 0;
    }

    public void increaseHeartbeatTimeoutCount() {
        ++this.heartbeatTimeoutCount;
    }

    public CloseReason getCloseReason() {
        return this.closeReason;
    }

    public void setCloseReason(CloseReason closeReason) {
        this.closeReason = closeReason;
    }

    public int getHeartbeatTimeoutCount() {
        return this.heartbeatTimeoutCount;
    }

    public void setHeartbeatTimeoutCount(int heartbeatTimeoutCount) {
        this.heartbeatTimeoutCount = heartbeatTimeoutCount;
    }

    public LocalDateTime getOccurTime() {
        return this.occurTime;
    }

    public void setOccurTime(LocalDateTime occurTime) {
        this.occurTime = occurTime;
    }
}

