/*
 * Decompiled with CFR 0.152.
 */
package me.hekr.iotos.softgateway.network.tcp;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import java.net.InetSocketAddress;
import java.util.List;
import me.hekr.iotos.softgateway.network.common.DecodePacket;
import me.hekr.iotos.softgateway.network.common.InternalPacket;
import me.hekr.iotos.softgateway.network.common.coder.PacketCoder;

@ChannelHandler.Sharable
class TcpCodecHandler<T>
extends MessageToMessageCodec<ByteBuf, InternalPacket<T>> {
    private final PacketCoder<T> packetCoder;

    public TcpCodecHandler(PacketCoder<T> packetCoder) {
        this.packetCoder = packetCoder;
    }

    protected void encode(ChannelHandlerContext ctx, InternalPacket<T> msg, List<Object> out) {
        byte[] bytes = this.packetCoder.encode(msg.getMessage());
        if (bytes != null) {
            out.add(Unpooled.wrappedBuffer((byte[])bytes));
        }
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf buf, List<Object> out) {
        byte[] bytes = ByteBufUtil.getBytes((ByteBuf)buf);
        DecodePacket p = this.packetCoder.decode(bytes);
        if (p != null && p != DecodePacket.NULL) {
            buf.readBytes(p.getReadSize());
            out.add(InternalPacket.wrap((Object)p.getResult(), (InetSocketAddress)((InetSocketAddress)ctx.channel().remoteAddress())));
        }
    }
}

