/*
 * Decompiled with CFR 0.152.
 */
package me.hekr.iotos.softgateway.network.tcp;

import cn.hutool.core.thread.ThreadUtil;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.timeout.IdleStateHandler;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import me.hekr.iotos.softgateway.network.common.InternalPacket;
import me.hekr.iotos.softgateway.network.common.coder.PacketCoder;
import me.hekr.iotos.softgateway.network.common.util.NetUtil;
import me.hekr.iotos.softgateway.network.tcp.ServerMessageHandler;
import me.hekr.iotos.softgateway.network.tcp.TcpCodecHandler;
import me.hekr.iotos.softgateway.network.tcp.TcpServerConnectionContext;
import me.hekr.iotos.softgateway.network.tcp.listener.EventListener;
import me.hekr.iotos.softgateway.network.tcp.listener.EventListenerAdapter;
import me.hekr.iotos.softgateway.network.tcp.listener.TcpMessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpServer<T> {
    private static final Logger log = LoggerFactory.getLogger(TcpServer.class);
    private ServerMessageHandler<T> messageHandler;
    private EventLoopGroup boss;
    private EventLoopGroup work;
    private int port;
    private EventListener<T> eventListener;
    private TcpMessageListener<T> messageListener;
    private int timeout;
    private boolean enableNetLog;
    private PacketCoder<T> packetCoder;

    public void setMessageListener(TcpMessageListener<T> messageListener) {
        Objects.requireNonNull(messageListener, "messageListener \u4e0d\u80fd\u4e3a null");
        this.messageListener = messageListener;
    }

    public void setPackageCoder(PacketCoder<T> packetCoder) {
        this.packetCoder = packetCoder;
    }

    public void setEventListener(EventListener<T> eventListener) {
        Objects.requireNonNull(eventListener, "eventListener \u4e0d\u80fd\u4e3a null");
        this.eventListener = eventListener;
    }

    public void bind(int port) {
        this.port = port;
    }

    public void setHeartbeatTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void start() {
        Objects.requireNonNull(this.messageListener, "\u5fc5\u987b\u8bbe\u7f6emessageListener");
        this.boss = new NioEventLoopGroup(2, ThreadUtil.newNamedThreadFactory((String)"netty-boss-", (boolean)false));
        this.work = new NioEventLoopGroup(2, ThreadUtil.newNamedThreadFactory((String)"netty-work-", (boolean)false));
        if (this.eventListener == null) {
            this.eventListener = new EventListenerAdapter();
        }
        this.messageHandler = new ServerMessageHandler<T>(this.messageListener, this.eventListener);
        ServerBootstrap bootstrap = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(this.boss, this.work).option(ChannelOption.ALLOCATOR, (Object)UnpooledByteBufAllocator.DEFAULT)).childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.ALLOCATOR, (Object)UnpooledByteBufAllocator.DEFAULT).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<NioSocketChannel>(){

            protected void initChannel(NioSocketChannel ch) {
                if (TcpServer.this.enableNetLog) {
                    ch.pipeline().addLast(new ChannelHandler[]{new LoggingHandler()});
                }
                ch.pipeline().addLast("idleStateHandler", (ChannelHandler)new IdleStateHandler((long)TcpServer.this.timeout, 0L, 0L, TimeUnit.MILLISECONDS)).addLast("tcpCodecHandler", new TcpCodecHandler(TcpServer.this.packetCoder)).addLast("messageHandler", (ChannelHandler)TcpServer.this.messageHandler);
            }
        });
        bootstrap.bind(this.port).syncUninterruptibly();
        log.info("\u7ed1\u5b9a\u7aef\u53e3\uff1a" + this.port + " \u6210\u529f\uff0c\u53ef\u4ee5\u63a5\u6536\u6d88\u606f\u4e86");
    }

    public void close() {
        NetUtil.close((EventLoopGroup)this.boss);
        NetUtil.close((EventLoopGroup)this.work);
    }

    public void writeAndFlush(TcpServerConnectionContext<T> ctx, T msg) {
        ctx.setLastSendTime(LocalDateTime.now());
        ctx.getChannel().writeAndFlush((Object)InternalPacket.wrap(msg)).addListener(f -> {
            if (log.isDebugEnabled()) {
                if (f.isSuccess()) {
                    log.debug("\u53d1\u9001\uff1a " + msg + " \u6210\u529f");
                } else {
                    log.error("\u53d1\u9001\u6d88\u606f\uff1a" + msg + " \u5931\u8d25\uff0c" + f.cause().getMessage(), f.cause());
                }
            }
        });
    }

    public void setEnableNetLog(boolean enableNetLog) {
        this.enableNetLog = enableNetLog;
    }
}

