/*
 * Decompiled with CFR 0.152.
 */
package me.hekr.iotos.softgateway.network.tcp;

import io.netty.channel.ChannelHandlerContext;
import java.net.InetSocketAddress;
import java.time.LocalDateTime;
import me.hekr.iotos.softgateway.network.common.CloseReason;
import me.hekr.iotos.softgateway.network.common.ConnectionContext;
import me.hekr.iotos.softgateway.network.common.InternalPacket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpServerConnectionContext<T>
extends ConnectionContext<T> {
    private static final Logger log = LoggerFactory.getLogger(TcpServerConnectionContext.class);
    protected final ChannelHandlerContext ctx;
    protected CloseReason closeReason;
    protected int heartbeatTimeoutCount = 0;
    protected LocalDateTime occurTime;

    public void writeAndFlush(T msg) {
        this.getChannel().writeAndFlush((Object)InternalPacket.wrap(msg)).addListener(f -> {
            if (log.isDebugEnabled()) {
                if (f.isSuccess()) {
                    log.debug("\u53d1\u9001\uff1a " + msg + " \u6210\u529f");
                } else {
                    log.error("\u53d1\u9001\u6d88\u606f\uff1a" + msg + " \u5931\u8d25\uff0c" + f.cause().getMessage(), f.cause());
                }
            }
        });
    }

    TcpServerConnectionContext(ChannelHandlerContext ctx, InetSocketAddress address, T message) {
        super(address, message);
        this.ctx = ctx;
        this.channel = ctx.channel();
    }

    public static <T> ConnectionContext<T> wrap(ChannelHandlerContext ctx, InetSocketAddress address, T message) {
        return new TcpServerConnectionContext<T>(ctx, address, message);
    }

    public static <T> TcpServerConnectionContext<T> wrap(ChannelHandlerContext ctx) {
        return new TcpServerConnectionContext<Object>(ctx, null, null);
    }

    public static <T> TcpServerConnectionContext<T> wrap(ChannelHandlerContext ctx, InetSocketAddress remoteAddress) {
        return new TcpServerConnectionContext<Object>(ctx, remoteAddress, null);
    }

    public void resetHeartbeatTimeoutCount() {
        this.heartbeatTimeoutCount = 0;
    }

    public void increaseHeartbeatTimeoutCount() {
        ++this.heartbeatTimeoutCount;
    }

    public CloseReason getCloseReason() {
        return this.closeReason;
    }

    public void setCloseReason(CloseReason closeReason) {
        this.closeReason = closeReason;
    }

    public int getHeartbeatTimeoutCount() {
        return this.heartbeatTimeoutCount;
    }

    public void setHeartbeatTimeoutCount(int heartbeatTimeoutCount) {
        this.heartbeatTimeoutCount = heartbeatTimeoutCount;
    }

    public LocalDateTime getOccurTime() {
        return this.occurTime;
    }

    public void setOccurTime(LocalDateTime occurTime) {
        this.occurTime = occurTime;
    }
}

