/*
 * Decompiled with CFR 0.152.
 */
package me.hekr.iotos.softgateway.network.tcp;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.AttributeKey;
import java.net.InetSocketAddress;
import java.time.LocalDateTime;
import me.hekr.iotos.softgateway.network.common.CloseReason;
import me.hekr.iotos.softgateway.network.common.ConnectionContext;
import me.hekr.iotos.softgateway.network.common.InternalPacket;
import me.hekr.iotos.softgateway.network.tcp.TcpServerConnectionContext;
import me.hekr.iotos.softgateway.network.tcp.listener.EventListener;
import me.hekr.iotos.softgateway.network.tcp.listener.TcpMessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class ServerMessageHandler<T>
extends SimpleChannelInboundHandler<InternalPacket<T>> {
    private static final Logger log = LoggerFactory.getLogger(ServerMessageHandler.class);
    private static final AttributeKey<ConnectionContext<?>> PACKET_CONTEXT = AttributeKey.valueOf((String)"_PACKET_CONTEXT_");
    private final TcpMessageListener<T> messageListener;
    private final EventListener<T> eventListener;

    public ServerMessageHandler(TcpMessageListener<T> messageListener, EventListener<T> eventListener) {
        this.messageListener = messageListener;
        this.eventListener = eventListener;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        TcpServerConnectionContext packetContext = TcpServerConnectionContext.wrap(ctx, (InetSocketAddress)ctx.channel().remoteAddress());
        ctx.channel().attr(PACKET_CONTEXT).set(packetContext);
        this.eventListener.onConnect(packetContext);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        TcpServerConnectionContext<T> packetContext = this.getPacketContext(ctx);
        CloseReason closeReason = packetContext.getCloseReason();
        if (closeReason == null) {
            closeReason = CloseReason.CLIENT_CLOSE;
            packetContext.setCloseReason(closeReason);
        }
        this.eventListener.onDisconnect(packetContext, closeReason);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            IdleState state = ((IdleStateEvent)evt).state();
            TcpServerConnectionContext<T> packetContext = this.getPacketContext(ctx);
            packetContext.increaseHeartbeatTimeoutCount();
            LocalDateTime lastOccurTime = packetContext.getOccurTime();
            packetContext.setOccurTime(LocalDateTime.now());
            this.eventListener.onHeartbeatTimeout(packetContext, lastOccurTime, packetContext.getHeartbeatTimeoutCount());
        }
    }

    protected void channelRead0(ChannelHandlerContext ctx, InternalPacket<T> packet) {
        TcpServerConnectionContext<T> packetContext = this.getPacketContext(ctx);
        packetContext.resetHeartbeatTimeoutCount();
        packetContext.setMessage(packet.getMessage());
        packetContext.setLastReceiveTime(LocalDateTime.now());
        this.messageListener.onMessage(packetContext);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.eventListener.exceptionCaught(this.getPacketContext(ctx), cause);
    }

    private TcpServerConnectionContext<T> getPacketContext(ChannelHandlerContext ctx) {
        return (TcpServerConnectionContext)((Object)ctx.channel().attr(PACKET_CONTEXT).get());
    }
}

