/*
 * Decompiled with CFR 0.152.
 */
package me.hekr.iotos.softgateway.network.udp;

import java.net.InetSocketAddress;
import me.hekr.iotos.softgateway.network.common.InternalPacket;
import me.hekr.iotos.softgateway.network.common.PacketContext;
import me.hekr.iotos.softgateway.network.common.coder.PacketCoder;
import me.hekr.iotos.softgateway.network.udp.UdpClient;
import me.hekr.iotos.softgateway.network.udp.UdpCodecHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UdpServer<T>
extends UdpClient<T> {
    private static final Logger log = LoggerFactory.getLogger(UdpServer.class);

    public UdpServer(String host, int port, int bindPort) {
        super(host, port, bindPort);
    }

    public UdpServer(int bindPort) {
        super(null, 0, bindPort);
    }

    @Override
    public void setPacketCoder(PacketCoder<T> packetCoder) {
        this.packetCoderHandler = new UdpCodecHandler<T>(packetCoder);
    }

    public T send(String host, int port, T t) {
        InternalPacket internalPacket = InternalPacket.wrap(t, (InetSocketAddress)new InetSocketAddress(host, port));
        return (T)this.doSend(internalPacket);
    }

    public T send(PacketContext<T> ctx, T t) {
        return this.send(ctx.getAddress(), t);
    }

    public T send(InetSocketAddress address, T t) {
        InternalPacket internalPacket = InternalPacket.wrap(t, (InetSocketAddress)address);
        return (T)this.doSend(internalPacket);
    }
}

