/*
 * Decompiled with CFR 0.152.
 */
package me.hekr.iotos.softgateway.network.udp;

import io.netty.channel.socket.nio.NioDatagramChannel;
import java.net.InetSocketAddress;
import me.hekr.iotos.softgateway.network.common.InternalPacket;
import me.hekr.iotos.softgateway.network.common.client.AbstractClient;
import me.hekr.iotos.softgateway.network.common.coder.PacketCoder;
import me.hekr.iotos.softgateway.network.udp.UdpCodecHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UdpClient<T>
extends AbstractClient<T> {
    private static final Logger log = LoggerFactory.getLogger(UdpClient.class);

    public UdpClient(String host, int port, int bindPort) {
        super(NioDatagramChannel.class, 2048);
        this.host = host;
        this.port = port;
        this.bindPort = bindPort;
    }

    public UdpClient(String host, int port, int bindPort, int maxDatagramSize) {
        super(NioDatagramChannel.class, maxDatagramSize);
        this.host = host;
        this.port = port;
        this.bindPort = bindPort;
    }

    public void setPacketCoder(PacketCoder<T> packetCoder) {
        this.packetCoderHandlerFactory = () -> new UdpCodecHandler(packetCoder);
    }

    public T sendBroadcast(T t, int port) {
        return (T)this.doSend(InternalPacket.wrap(t, (InetSocketAddress)new InetSocketAddress("255.255.255.255", port)));
    }
}

