/*
 * Decompiled with CFR 0.152.
 */
package me.hekr.iotos.softgateway.network.udp;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.DatagramPacket;
import io.netty.handler.codec.MessageToMessageCodec;
import java.net.InetSocketAddress;
import java.util.List;
import me.hekr.iotos.softgateway.network.common.DecodePacket;
import me.hekr.iotos.softgateway.network.common.InternalPacket;
import me.hekr.iotos.softgateway.network.common.coder.PacketCoder;

class UdpCodecHandler<T>
extends MessageToMessageCodec<DatagramPacket, InternalPacket<T>> {
    private final PacketCoder<T> packetCoder;

    public UdpCodecHandler(PacketCoder<T> udCoder) {
        this.packetCoder = udCoder;
    }

    protected void encode(ChannelHandlerContext ctx, InternalPacket<T> msg, List<Object> out) {
        byte[] bytes = this.packetCoder.encode(msg.getMessage());
        if (bytes != null) {
            DatagramPacket datagramPacket = new DatagramPacket(Unpooled.wrappedBuffer((byte[])bytes), msg.getAddress());
            out.add(datagramPacket);
        }
    }

    protected void decode(ChannelHandlerContext ctx, DatagramPacket msg, List<Object> out) {
        ByteBuf buf = (ByteBuf)msg.content();
        byte[] bytes = new byte[buf.readableBytes()];
        buf.readBytes(bytes);
        DecodePacket o = this.packetCoder.decode(bytes);
        if (o != null) {
            out.add(InternalPacket.wrap((Object)o.getResult(), (InetSocketAddress)((InetSocketAddress)msg.sender())));
        }
    }
}

