/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.addon;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import me.hsgamer.hscore.addon.loader.AddonDescriptionLoader;
import me.hsgamer.hscore.addon.object.Addon;
import me.hsgamer.hscore.addon.object.AddonClassLoader;
import me.hsgamer.hscore.addon.object.AddonDescription;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddonManager {
    protected final Map<String, Addon> addons = new LinkedHashMap<String, Addon>();
    protected final Map<Addon, AddonClassLoader> loaderMap = new HashMap<Addon, AddonClassLoader>();
    @NotNull
    private final File addonsDir;
    @NotNull
    private final Logger logger;
    @NotNull
    private final ClassLoader parentClassLoader;
    @NotNull
    private final AddonDescriptionLoader addonDescriptionLoader;

    protected AddonManager(@NotNull File addonsDir, @NotNull Logger logger, @NotNull AddonDescriptionLoader addonDescriptionLoader) {
        this(addonsDir, logger, addonDescriptionLoader, AddonManager.class.getClassLoader());
    }

    public AddonManager(@NotNull File addonsDir, @NotNull Logger logger, @NotNull AddonDescriptionLoader addonDescriptionLoader, @NotNull ClassLoader parentClassLoader) {
        this.logger = logger;
        this.addonsDir = addonsDir;
        this.addonDescriptionLoader = addonDescriptionLoader;
        this.parentClassLoader = parentClassLoader;
        if (!addonsDir.exists()) {
            addonsDir.mkdirs();
        }
    }

    @NotNull
    public final File getAddonsDir() {
        return this.addonsDir;
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public AddonDescriptionLoader getAddonDescriptionLoader() {
        return this.addonDescriptionLoader;
    }

    public void loadAddons() {
        HashMap<String, Addon> addonMap = new HashMap<String, Addon>();
        Arrays.stream(Objects.requireNonNull(this.addonsDir.listFiles())).filter(file -> file.isFile() && file.getName().endsWith(".jar")).forEach(file -> {
            try (JarFile jar = new JarFile((File)file);){
                AddonDescription addonDescription = this.addonDescriptionLoader.load(jar);
                if (addonMap.containsKey(addonDescription.getName())) {
                    this.logger.warning("Duplicated addon " + addonDescription.getName());
                    return;
                }
                AddonClassLoader loader = new AddonClassLoader(this, (File)file, addonDescription, this.parentClassLoader);
                Addon addon = loader.getAddon();
                if (this.onAddonLoading(addon)) {
                    addonMap.put(addonDescription.getName(), loader.getAddon());
                    this.loaderMap.put(addon, loader);
                } else {
                    loader.close();
                }
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, e, () -> "Error when loading " + file.getName());
            }
        });
        Map<String, Addon> sortedAddonMap = this.sortAndFilter(addonMap);
        addonMap.entrySet().stream().filter(entry -> !sortedAddonMap.containsKey(entry.getKey())).forEach(entry -> this.closeClassLoader((Addon)entry.getValue()));
        LinkedHashMap finalAddons = new LinkedHashMap();
        sortedAddonMap.forEach((key, addon) -> {
            try {
                if (!addon.onLoad()) {
                    this.logger.warning("Failed to load " + key + " " + addon.getDescription().getVersion());
                    this.closeClassLoader((Addon)addon);
                    return;
                }
                this.logger.info("Loaded " + key + " " + addon.getDescription().getVersion());
                finalAddons.put(key, addon);
            }
            catch (Throwable t) {
                this.logger.log(Level.WARNING, t, () -> "Error when loading " + key);
                this.closeClassLoader((Addon)addon);
            }
        });
        this.addons.putAll(finalAddons);
    }

    public boolean enableAddon(@NotNull String name, boolean closeLoaderOnFailed) {
        Addon addon = this.addons.get(name);
        try {
            this.onAddonEnable(addon);
            addon.onEnable();
            this.onAddonEnabled(addon);
            return true;
        }
        catch (Throwable t) {
            this.logger.log(Level.WARNING, t, () -> "Error when enabling " + name);
            if (closeLoaderOnFailed) {
                this.closeClassLoader(addon);
            }
            return false;
        }
    }

    public boolean disableAddon(@NotNull String name, boolean closeLoaderOnFailed) {
        Addon addon = this.addons.get(name);
        try {
            this.onAddonDisable(addon);
            addon.onDisable();
            this.onAddonDisabled(addon);
            return true;
        }
        catch (Throwable t) {
            this.logger.log(Level.WARNING, t, () -> "Error when disabling " + name);
            if (closeLoaderOnFailed) {
                this.closeClassLoader(addon);
            }
            return false;
        }
    }

    public void enableAddons() {
        LinkedList failed = new LinkedList();
        this.addons.keySet().forEach(name -> {
            if (!this.enableAddon((String)name, true)) {
                failed.add(name);
            } else {
                this.logger.log(Level.INFO, "Enabled {0}", String.join((CharSequence)" ", name, this.addons.get(name).getDescription().getVersion()));
            }
        });
        failed.forEach(this.addons::remove);
    }

    public void callPostEnable() {
        this.addons.values().forEach(Addon::onPostEnable);
    }

    public void callReload() {
        this.addons.values().forEach(Addon::onReload);
    }

    public void disableAddons() {
        String name;
        LinkedList<String> stack = new LinkedList<String>(this.addons.keySet());
        while ((name = (String)stack.pollLast()) != null) {
            if (!this.disableAddon(name, false)) continue;
            this.logger.log(Level.INFO, "Disabled {0}", String.join((CharSequence)" ", name, this.addons.get(name).getDescription().getVersion()));
        }
        this.addons.values().forEach(this::closeClassLoader);
        this.addons.clear();
    }

    @Nullable
    public Addon getAddon(@NotNull String name) {
        return this.addons.get(name);
    }

    public boolean isAddonLoaded(@NotNull String name) {
        return this.addons.containsKey(name);
    }

    @NotNull
    public Map<String, Addon> getLoadedAddons() {
        return Collections.unmodifiableMap(this.addons);
    }

    @Nullable
    public Class<?> findClass(@NotNull Addon addon, @NotNull String name) {
        return this.loaderMap.entrySet().parallelStream().filter(entry -> entry.getKey() != addon).flatMap(entry -> Optional.ofNullable(((AddonClassLoader)entry.getValue()).findClass(name, false)).map(Stream::of).orElse(Stream.empty())).findAny().orElse(null);
    }

    @NotNull
    protected Map<String, Addon> sortAndFilter(@NotNull Map<String, Addon> original) {
        return original;
    }

    protected boolean onAddonLoading(@NotNull Addon addon) {
        return true;
    }

    protected void onAddonEnable(@NotNull Addon addon) {
    }

    protected void onAddonEnabled(@NotNull Addon addon) {
    }

    protected void onAddonDisable(@NotNull Addon addon) {
    }

    protected void onAddonDisabled(@NotNull Addon addon) {
    }

    private void closeClassLoader(@NotNull Addon addon) {
        if (this.loaderMap.containsKey(addon)) {
            AddonClassLoader loader = this.loaderMap.remove(addon);
            try {
                loader.close();
            }
            catch (IOException e) {
                this.logger.log(Level.WARNING, "Error when closing ClassLoader", e);
            }
        }
    }
}

