/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.addon.loader;

import java.io.IOException;
import java.util.HashMap;
import java.util.Objects;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import me.hsgamer.hscore.addon.exception.InvalidAddonDescription;
import me.hsgamer.hscore.addon.loader.AddonDescriptionLoader;
import me.hsgamer.hscore.addon.object.AddonDescription;

public class ManifestAddonDescriptionLoader
implements AddonDescriptionLoader {
    @Override
    public AddonDescription load(JarFile jarFile) throws IOException, InvalidAddonDescription {
        Manifest manifest = jarFile.getManifest();
        if (manifest == null) {
            throw new InvalidAddonDescription(jarFile.getName() + " does not have a manifest");
        }
        Attributes attributes = manifest.getMainAttributes();
        String name = attributes.getValue("Implementation-Title");
        if (name == null) {
            throw new InvalidAddonDescription(jarFile.getName() + " does not have a Implementation-Title");
        }
        String version = attributes.getValue("Implementation-Version");
        if (version == null) {
            throw new InvalidAddonDescription(jarFile.getName() + " does not have a Implementation-Version");
        }
        String mainClass = attributes.getValue("Main-Class");
        if (mainClass == null) {
            throw new InvalidAddonDescription(jarFile.getName() + " does not have a Main-Class");
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        attributes.forEach((key, value) -> data.put(Objects.toString(key), value));
        return new AddonDescription(name, version, mainClass, data);
    }
}

