/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.addon.object;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import me.hsgamer.hscore.addon.AddonManager;
import me.hsgamer.hscore.addon.object.Addon;
import me.hsgamer.hscore.addon.object.AddonDescription;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AddonClassLoader
extends URLClassLoader {
    @NotNull
    private final Addon addon;
    @NotNull
    private final File file;
    @NotNull
    private final AddonManager addonManager;
    @NotNull
    private final AddonDescription addonDescription;

    public AddonClassLoader(@NotNull AddonManager addonManager, @NotNull File file, @NotNull AddonDescription addonDescription, @NotNull ClassLoader parent) throws MalformedURLException, IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchMethodException, ClassNotFoundException {
        super(new URL[]{file.toURI().toURL()}, parent);
        this.addonManager = addonManager;
        this.file = file;
        this.addonDescription = addonDescription;
        Class<?> clazz = Class.forName(addonDescription.getMainClass(), true, this);
        if (!Addon.class.isAssignableFrom(clazz)) {
            throw new ClassCastException("The main class does not extend Addon");
        }
        Class<Addon> newClass = clazz.asSubclass(Addon.class);
        this.addon = newClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    @NotNull
    public Addon getAddon() {
        return this.addon;
    }

    @Nullable
    public Class<?> findClass(@NotNull String name, boolean global) {
        Class<?> clazz;
        block2: {
            clazz = null;
            try {
                clazz = super.findClass(name);
            }
            catch (ClassNotFoundException | NoClassDefFoundError e) {
                if (!global) break block2;
                clazz = this.addonManager.findClass(this.addon, name);
            }
        }
        return clazz;
    }

    @NotNull
    public File getFile() {
        return this.file;
    }

    @NotNull
    public AddonManager getAddonManager() {
        return this.addonManager;
    }

    @NotNull
    public AddonDescription getAddonDescription() {
        return this.addonDescription;
    }

    @Override
    @NotNull
    protected Class<?> findClass(@NotNull String name) throws ClassNotFoundException {
        Class<?> clazz = this.findClass(name, true);
        if (clazz == null) {
            throw new ClassNotFoundException(name);
        }
        return clazz;
    }
}

