/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.addon.object;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import me.hsgamer.hscore.addon.AddonManager;
import me.hsgamer.hscore.addon.object.AddonClassLoader;
import me.hsgamer.hscore.addon.object.AddonDescription;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Addon {
    private final AddonClassLoader addonClassLoader;
    private File dataFolder;

    public Addon() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (!(classLoader instanceof AddonClassLoader)) {
            throw new IllegalStateException("Cannot create an addon without AddonClassLoader");
        }
        this.addonClassLoader = (AddonClassLoader)classLoader;
    }

    public boolean onLoad() {
        return true;
    }

    public void onEnable() {
    }

    public void onPostEnable() {
    }

    public void onDisable() {
    }

    public void onReload() {
    }

    @NotNull
    public final AddonDescription getDescription() {
        return this.addonClassLoader.getAddonDescription();
    }

    @NotNull
    public final AddonManager getAddonManager() {
        return this.addonClassLoader.getAddonManager();
    }

    @NotNull
    public final File getDataFolder() {
        if (this.dataFolder == null) {
            this.dataFolder = new File(this.getAddonManager().getAddonsDir(), this.getDescription().getName());
        }
        if (!this.dataFolder.exists()) {
            this.dataFolder.mkdirs();
        }
        return this.dataFolder;
    }

    public final void saveResource(@NotNull String path, boolean replace) {
        block17: {
            if (path.isEmpty()) {
                throw new IllegalArgumentException("Path cannot be null or empty");
            }
            String newPath = path.replace('\\', '/');
            try (JarFile jar = new JarFile(this.addonClassLoader.getFile());){
                JarEntry jarConfig = jar.getJarEntry(newPath);
                if (jarConfig != null) {
                    try (InputStream in = jar.getInputStream(jarConfig);){
                        if (in == null) {
                            throw new IllegalArgumentException("The embedded resource '" + newPath + "' cannot be found");
                        }
                        File out = new File(this.getDataFolder(), newPath);
                        out.getParentFile().mkdirs();
                        if (!out.exists() || replace) {
                            Files.copy(in, out.toPath(), StandardCopyOption.REPLACE_EXISTING);
                        }
                        break block17;
                    }
                }
                throw new IllegalArgumentException("The embedded resource '" + newPath + "' cannot be found");
            }
            catch (IOException e) {
                this.getAddonManager().getLogger().warning("Could not load from jar file. " + newPath);
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public final InputStream getResource(@NotNull String path) {
        block14: {
            if (path.isEmpty()) {
                throw new IllegalArgumentException("Path cannot be null or empty");
            }
            String newPath = path.replace('\\', '/');
            try (JarFile jar = new JarFile(this.addonClassLoader.getFile());){
                InputStream inputStream;
                block15: {
                    JarEntry jarConfig = jar.getJarEntry(newPath);
                    if (jarConfig == null) break block14;
                    InputStream in = jar.getInputStream(jarConfig);
                    try {
                        inputStream = in;
                        if (in == null) break block15;
                    }
                    catch (Throwable throwable) {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    in.close();
                }
                return inputStream;
            }
            catch (IOException e) {
                this.getAddonManager().getLogger().warning("Could not load from jar file. " + newPath);
            }
        }
        return null;
    }

    @NotNull
    public final AddonClassLoader getClassLoader() {
        return this.addonClassLoader;
    }
}

