/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.addon;

import java.io.File;
import java.util.function.Function;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import me.hsgamer.hscore.addon.object.Addon;
import me.hsgamer.hscore.expansion.common.ExpansionDescription;
import me.hsgamer.hscore.expansion.common.ExpansionManager;
import org.jetbrains.annotations.NotNull;

public class AddonManager
extends ExpansionManager {
    private final Logger logger;

    public AddonManager(@NotNull File addonsDir, @NotNull Logger logger, @NotNull Function<JarFile, ExpansionDescription> addonDescriptionLoader, @NotNull ClassLoader parentClassLoader) {
        super(addonsDir, addonDescriptionLoader, parentClassLoader);
        this.logger = logger;
        this.addStateListener((loader, state) -> {
            Addon addon = loader.getExpansionOptional().filter(Addon.class::isInstance).map(Addon.class::cast).orElse(null);
            if (addon == null) {
                return;
            }
            switch (state) {
                case LOADING: {
                    if (this.onAddonLoading(addon)) break;
                    throw new IllegalStateException("Cannot load " + loader.getDescription().getName());
                }
                case ENABLING: {
                    this.onAddonEnable(addon);
                    break;
                }
                case ENABLED: {
                    this.onAddonEnabled(addon);
                    break;
                }
                case DISABLING: {
                    this.onAddonDisable(addon);
                    break;
                }
                case DISABLED: {
                    this.onAddonDisabled(addon);
                    break;
                }
            }
        });
        this.addStateListener((loader, state) -> {
            switch (state) {
                case ERROR: {
                    logger.log(Level.WARNING, loader.getThrowable(), () -> "There is an error in " + loader.getDescription().getName());
                    break;
                }
                case LOADED: {
                    logger.info(() -> "Loaded " + loader.getDescription().getName() + " " + loader.getDescription().getVersion());
                    break;
                }
                case ENABLED: {
                    logger.info(() -> "Enabled " + loader.getDescription().getName() + " " + loader.getDescription().getVersion());
                    break;
                }
                case DISABLED: {
                    logger.info(() -> "Disabled " + loader.getDescription().getName() + " " + loader.getDescription().getVersion());
                    break;
                }
            }
        });
        this.setExceptionHandler(t -> logger.log(Level.WARNING, "There is an unexpected exception on AddonManager", (Throwable)t));
    }

    public AddonManager(@NotNull File addonsDir, @NotNull Logger logger, @NotNull Function<JarFile, ExpansionDescription> addonDescriptionLoader) {
        this(addonsDir, logger, addonDescriptionLoader, AddonManager.class.getClassLoader());
    }

    public void callPostEnable() {
        this.call(Addon.class, Addon::onPostEnable);
    }

    public void callReload() {
        this.call(Addon.class, Addon::onReload);
    }

    protected boolean onAddonLoading(@NotNull Addon addon) {
        return true;
    }

    protected void onAddonEnable(@NotNull Addon addon) {
    }

    protected void onAddonEnabled(@NotNull Addon addon) {
    }

    protected void onAddonDisable(@NotNull Addon addon) {
    }

    protected void onAddonDisabled(@NotNull Addon addon) {
    }

    public Logger getLogger() {
        return this.logger;
    }
}

