/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.addon.loader;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.jar.JarFile;
import me.hsgamer.hscore.addon.exception.InvalidAddonDescription;
import me.hsgamer.hscore.addon.loader.AddonDescriptionLoader;
import me.hsgamer.hscore.addon.object.AddonDescription;

public interface MapAddonDescriptionLoader
extends AddonDescriptionLoader {
    public Map<String, Object> loadAsMap(JarFile var1) throws IOException, InvalidAddonDescription;

    @Override
    default public AddonDescription load(JarFile jarFile) throws IOException, InvalidAddonDescription {
        Map<String, Object> data = this.loadAsMap(jarFile);
        String name = Objects.toString(data.get("name"), null);
        String version = Objects.toString(data.get("version"), null);
        String mainClass = Objects.toString(data.get("main"), null);
        if (name == null) {
            throw new InvalidAddonDescription(jarFile.getName() + " doesn't define a name");
        }
        if (version == null) {
            throw new InvalidAddonDescription(jarFile.getName() + " doesn't define a version");
        }
        if (mainClass == null) {
            throw new IllegalArgumentException(jarFile.getName() + " doesn't define a main class");
        }
        return new AddonDescription(name, version, mainClass, data);
    }
}

