/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.bukkit.action;

import io.github.projectunified.minelib.scheduler.entity.EntityScheduler;
import java.util.UUID;
import me.hsgamer.hscore.action.common.Action;
import me.hsgamer.hscore.common.StringReplacer;
import me.hsgamer.hscore.task.element.TaskProcess;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class DelayAction
implements Action {
    private final Plugin plugin;
    private final String delay;

    public DelayAction(Plugin plugin, String delay) {
        this.plugin = plugin;
        this.delay = delay;
    }

    public void apply(UUID uuid, TaskProcess process, StringReplacer stringReplacer) {
        long delay;
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player == null) {
            process.next();
            return;
        }
        String value = stringReplacer.replaceOrOriginal(this.delay, uuid);
        try {
            delay = Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            this.plugin.getLogger().warning("Invalid delay: " + value);
            process.next();
            return;
        }
        EntityScheduler.get((Plugin)this.plugin, (Entity)player).runLater(() -> ((TaskProcess)process).next(), () -> ((TaskProcess)process).next(), delay);
    }
}

