/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.bukkit.baseplugin;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import me.hsgamer.hscore.bukkit.command.CommandManager;
import me.hsgamer.hscore.bukkit.simpleplugin.SimplePlugin;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.permissions.Permission;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class BasePlugin
extends SimplePlugin {
    private final CommandManager commandManager = new CommandManager((JavaPlugin)this);
    private final Set<Permission> registeredPermissions = new HashSet<Permission>();

    public final void onLoad() {
        super.onLoad();
    }

    public final void onEnable() {
        super.onEnable();
        this.registerPermissions();
        this.addPostEnableRunnable(CommandManager::syncCommand);
    }

    public final void onDisable() {
        super.onDisable();
        this.commandManager.unregisterAll();
        this.registeredPermissions.forEach(arg_0 -> ((PluginManager)Bukkit.getPluginManager()).removePermission(arg_0));
    }

    private void registerPermissions() {
        for (Class<?> clazz : this.getPermissionClasses()) {
            for (Field field : clazz.getDeclaredFields()) {
                int modifiers = field.getModifiers();
                if (!field.getType().equals(Permission.class) || !Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) continue;
                try {
                    Permission permission = (Permission)field.get(null);
                    this.registerPermission(permission);
                }
                catch (IllegalAccessException e) {
                    this.getLogger().log(Level.WARNING, "Failed to register permission", e);
                }
            }
        }
    }

    protected List<Class<?>> getPermissionClasses() {
        return Collections.singletonList(((Object)((Object)this)).getClass());
    }

    public void registerPermission(Permission permission) {
        Bukkit.getPluginManager().addPermission(permission);
        this.registeredPermissions.add(permission);
    }

    public void registerCommand(Command command) {
        this.commandManager.register(command);
    }

    public Command getRegisteredCommand(String label) {
        Command command = (Command)this.commandManager.getRegistered().get(label);
        return command != null ? command : this.getCommand(label);
    }

    public CommandManager getCommandManager() {
        return this.commandManager;
    }
}

