/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.bukkit.block.iterator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import me.hsgamer.hscore.bukkit.block.box.BlockBox;
import me.hsgamer.hscore.bukkit.block.iterator.VectorIterator;
import me.hsgamer.hscore.bukkit.block.iterator.impl.LinearVectorIterator;
import me.hsgamer.hscore.bukkit.block.iterator.impl.RandomTypeVectorIterator;
import me.hsgamer.hscore.bukkit.block.iterator.impl.RandomVectorIterator;
import me.hsgamer.hscore.collections.map.CaseInsensitiveStringHashMap;

public final class VectorIteratorUtil {
    private static final Map<String, Function<BlockBox, VectorIterator>> TYPE_MAP = new CaseInsensitiveStringHashMap();

    private VectorIteratorUtil() {
    }

    public static void registerType(String type, Function<BlockBox, VectorIterator> typeFunction) {
        TYPE_MAP.put(type, typeFunction);
    }

    public static VectorIterator random(BlockBox box) {
        return new RandomTypeVectorIterator(box, new ArrayList<Function<BlockBox, VectorIterator>>(TYPE_MAP.values()));
    }

    public static VectorIterator get(String type, BlockBox box) {
        return TYPE_MAP.getOrDefault(type, VectorIteratorUtil::random).apply(box);
    }

    public Collection<String> getRegisteredTypes() {
        return Collections.unmodifiableSet(TYPE_MAP.keySet());
    }

    static {
        VectorIteratorUtil.registerType("random", RandomVectorIterator::new);
        VectorIteratorUtil.registerType("xyz", box -> new LinearVectorIterator((BlockBox)box, LinearVectorIterator.X_COORDINATE, LinearVectorIterator.Y_COORDINATE, LinearVectorIterator.Z_COORDINATE));
        VectorIteratorUtil.registerType("xzy", box -> new LinearVectorIterator((BlockBox)box, LinearVectorIterator.X_COORDINATE, LinearVectorIterator.Z_COORDINATE, LinearVectorIterator.Y_COORDINATE));
        VectorIteratorUtil.registerType("yxz", box -> new LinearVectorIterator((BlockBox)box, LinearVectorIterator.Y_COORDINATE, LinearVectorIterator.X_COORDINATE, LinearVectorIterator.Z_COORDINATE));
        VectorIteratorUtil.registerType("yzx", box -> new LinearVectorIterator((BlockBox)box, LinearVectorIterator.Y_COORDINATE, LinearVectorIterator.Z_COORDINATE, LinearVectorIterator.X_COORDINATE));
        VectorIteratorUtil.registerType("zxy", box -> new LinearVectorIterator((BlockBox)box, LinearVectorIterator.Z_COORDINATE, LinearVectorIterator.X_COORDINATE, LinearVectorIterator.Y_COORDINATE));
        VectorIteratorUtil.registerType("zyx", box -> new LinearVectorIterator((BlockBox)box, LinearVectorIterator.Z_COORDINATE, LinearVectorIterator.Y_COORDINATE, LinearVectorIterator.X_COORDINATE));
        VectorIteratorUtil.registerType("default", LinearVectorIterator::new);
    }
}

