/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.bukkit.block.iterator.impl;

import java.util.NoSuchElementException;
import me.hsgamer.hscore.bukkit.block.box.BlockBox;
import me.hsgamer.hscore.bukkit.block.iterator.BaseVectorIterator;
import org.bukkit.util.Vector;

public class LinearVectorIterator
extends BaseVectorIterator {
    public static final LinearCoordinate X_COORDINATE = new LinearCoordinate(){

        @Override
        public boolean hasNext(Vector current, BaseVectorIterator iterator) {
            return current.getX() < (double)iterator.box.maxX;
        }

        @Override
        public void next(Vector next) {
            next.setX(next.getX() + 1.0);
        }

        @Override
        public void reset(Vector next, BaseVectorIterator iterator) {
            next.setX(iterator.box.minX);
        }
    };
    public static final LinearCoordinate Y_COORDINATE = new LinearCoordinate(){

        @Override
        public boolean hasNext(Vector current, BaseVectorIterator iterator) {
            return current.getY() < (double)iterator.box.maxY;
        }

        @Override
        public void next(Vector next) {
            next.setY(next.getY() + 1.0);
        }

        @Override
        public void reset(Vector next, BaseVectorIterator iterator) {
            next.setY(iterator.box.minY);
        }
    };
    public static final LinearCoordinate Z_COORDINATE = new LinearCoordinate(){

        @Override
        public boolean hasNext(Vector current, BaseVectorIterator iterator) {
            return current.getZ() < (double)iterator.box.maxZ;
        }

        @Override
        public void next(Vector next) {
            next.setZ(next.getZ() + 1.0);
        }

        @Override
        public void reset(Vector next, BaseVectorIterator iterator) {
            next.setZ(iterator.box.minZ);
        }
    };
    private final LinearCoordinate[] coordinates;

    public LinearVectorIterator(BlockBox box, LinearCoordinate ... coordinates) {
        super(box);
        this.coordinates = coordinates;
    }

    public LinearVectorIterator(BlockBox box) {
        this(box, X_COORDINATE, Y_COORDINATE, Z_COORDINATE);
    }

    @Override
    public Vector initial() {
        return new Vector(this.box.minX, this.box.minY, this.box.minZ);
    }

    @Override
    public Vector getContinue(Vector current) throws NoSuchElementException {
        Vector next = current.clone();
        for (int i = 0; i < this.coordinates.length; ++i) {
            LinearCoordinate coordinate = this.coordinates[i];
            if (coordinate.hasNext(next, this)) {
                coordinate.next(next);
                break;
            }
            if (i == this.coordinates.length - 1) {
                throw new NoSuchElementException("No more elements");
            }
            coordinate.reset(next, this);
        }
        return next;
    }

    @Override
    public boolean hasContinue(Vector current) {
        return current.getX() < (double)this.box.maxX || current.getY() < (double)this.box.maxY || current.getZ() < (double)this.box.maxZ;
    }

    public static interface LinearCoordinate {
        public boolean hasNext(Vector var1, BaseVectorIterator var2);

        public void next(Vector var1);

        public void reset(Vector var1, BaseVectorIterator var2);
    }
}

