/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.bukkit.block.iterator.impl;

import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import me.hsgamer.hscore.bukkit.block.box.BlockBox;
import me.hsgamer.hscore.bukkit.block.iterator.AbstractVectorIterator;
import me.hsgamer.hscore.bukkit.block.iterator.VectorIterator;
import me.hsgamer.hscore.common.CollectionUtils;
import org.bukkit.util.Vector;

public class RandomTypeVectorIterator
extends AbstractVectorIterator {
    private final Collection<Function<BlockBox, VectorIterator>> functions;
    private final AtomicReference<VectorIterator> current;

    public RandomTypeVectorIterator(BlockBox box, Collection<Function<BlockBox, VectorIterator>> functions) {
        super(box);
        this.functions = functions;
        this.current = new AtomicReference<VectorIterator>(this.getRandom());
    }

    private VectorIterator getRandom() {
        return (VectorIterator)Objects.requireNonNull((Function)CollectionUtils.pickRandom(this.functions)).apply(this.box);
    }

    @Override
    public void reset() {
        this.current.set(this.getRandom());
    }

    @Override
    public boolean hasNext() {
        return this.current.get().hasNext();
    }

    @Override
    public Vector next() {
        return (Vector)this.current.get().next();
    }
}

