/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.bukkit.block.iterator.impl;

import java.util.Collections;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import me.hsgamer.hscore.bukkit.block.box.BlockBox;
import me.hsgamer.hscore.bukkit.block.iterator.BaseVectorIterator;
import org.bukkit.util.Vector;

public class RandomVectorIterator
extends BaseVectorIterator {
    private final LinkedList<Vector> queue = new LinkedList();

    public RandomVectorIterator(BlockBox box) {
        super(box);
    }

    @Override
    public void reset() {
        super.reset();
        this.queue.clear();
    }

    @Override
    public Vector initial() {
        for (int x = this.box.minX; x <= this.box.maxX; ++x) {
            for (int y = this.box.minY; y <= this.box.maxY; ++y) {
                for (int z = this.box.minZ; z <= this.box.maxZ; ++z) {
                    this.queue.add(new Vector(x, y, z));
                }
            }
        }
        Collections.shuffle(this.queue);
        return this.queue.poll();
    }

    @Override
    public Vector getContinue(Vector current) throws NoSuchElementException {
        Vector vector = this.queue.poll();
        if (vector == null) {
            throw new NoSuchElementException();
        }
        return vector;
    }

    @Override
    public boolean hasContinue(Vector current) {
        return !this.queue.isEmpty();
    }
}

