/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.bukkit.block.box;

import org.bukkit.Location;
import org.bukkit.util.Vector;

public class BlockBox {
    public final int minX;
    public final int minY;
    public final int minZ;
    public final int maxX;
    public final int maxY;
    public final int maxZ;
    public final boolean maxInclusive;

    public BlockBox(int x1, int y1, int z1, int x2, int y2, int z2, boolean maxInclusive) {
        this.minX = Math.min(x1, x2);
        this.minY = Math.min(y1, y2);
        this.minZ = Math.min(z1, z2);
        this.maxX = Math.max(x1, x2) + (maxInclusive ? 1 : 0);
        this.maxY = Math.max(y1, y2) + (maxInclusive ? 1 : 0);
        this.maxZ = Math.max(z1, z2) + (maxInclusive ? 1 : 0);
        this.maxInclusive = maxInclusive;
    }

    public BlockBox(Location loc1, Location loc2, boolean maxInclusive) {
        this(loc1.getBlockX(), loc1.getBlockY(), loc1.getBlockZ(), loc2.getBlockX(), loc2.getBlockY(), loc2.getBlockZ(), maxInclusive);
    }

    public BlockBox(Vector vec1, Vector vec2, boolean maxInclusive) {
        this(vec1.getBlockX(), vec1.getBlockY(), vec1.getBlockZ(), vec2.getBlockX(), vec2.getBlockY(), vec2.getBlockZ(), maxInclusive);
    }

    public boolean contains(double x, double y, double z) {
        return x >= (double)this.minX && x <= (double)this.maxX && y >= (double)this.minY && y <= (double)this.maxY && z >= (double)this.minZ && z <= (double)this.maxZ;
    }

    public boolean contains(Vector vec) {
        return this.contains(vec.getX(), vec.getY(), vec.getZ());
    }

    public boolean contains(Location loc) {
        return this.contains(loc.getX(), loc.getY(), loc.getZ());
    }
}

