/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.bukkit.channel;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.PluginMessageRecipient;

public final class BungeeUtils {
    private static final String BUNGEE_CHANNEL = "BungeeCord";
    private static Consumer<IOException> ioExceptionConsumer;

    private BungeeUtils() {
    }

    public static Consumer<IOException> getIoExceptionConsumer() {
        if (ioExceptionConsumer == null) {
            Logger logger = Logger.getLogger(BungeeUtils.class.getSimpleName());
            ioExceptionConsumer = e -> logger.log(Level.SEVERE, "Failed to send message to BungeeCord", (Throwable)e);
        }
        return ioExceptionConsumer;
    }

    public static void setIoExceptionConsumer(Consumer<IOException> ioExceptionConsumer) {
        BungeeUtils.ioExceptionConsumer = ioExceptionConsumer;
    }

    public static PluginMessageRecipient getGlobalRecipient() {
        return Bukkit.getServer();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] getDataBytes(DataOutputConsumer dataOutputConsumer) {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            byte[] byArray;
            try (DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);){
                dataOutputConsumer.accept(dataOutputStream);
                byArray = byteArrayOutputStream.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            BungeeUtils.getIoExceptionConsumer().accept(e);
            return new byte[0];
        }
    }

    public static void register(Plugin plugin, String channel) {
        if (!plugin.getServer().getMessenger().isOutgoingChannelRegistered(plugin, channel)) {
            plugin.getServer().getMessenger().registerOutgoingPluginChannel(plugin, channel);
        }
    }

    public static void unregister(Plugin plugin, String channel) {
        if (plugin.getServer().getMessenger().isOutgoingChannelRegistered(plugin, channel)) {
            plugin.getServer().getMessenger().unregisterOutgoingPluginChannel(plugin, channel);
        }
    }

    public static void register(Plugin plugin) {
        BungeeUtils.register(plugin, BUNGEE_CHANNEL);
    }

    public static void unregister(Plugin plugin) {
        BungeeUtils.unregister(plugin, BUNGEE_CHANNEL);
    }

    public static void sendPluginMessage(Plugin plugin, PluginMessageRecipient recipient, String channel, byte[] data) {
        recipient.sendPluginMessage(plugin, channel, data);
    }

    public static void sendPluginMessage(Plugin plugin, PluginMessageRecipient recipient, byte[] data) {
        BungeeUtils.sendPluginMessage(plugin, recipient, BUNGEE_CHANNEL, data);
    }

    public static void connectToServer(Plugin plugin, PluginMessageRecipient recipient, String server) {
        BungeeUtils.sendPluginMessage(plugin, recipient, BungeeUtils.getDataBytes(dataStream -> {
            dataStream.writeUTF("Connect");
            dataStream.writeUTF(server);
        }));
    }

    public static void connectOtherToServer(Plugin plugin, PluginMessageRecipient recipient, String playerName, String server) {
        BungeeUtils.sendPluginMessage(plugin, recipient, BungeeUtils.getDataBytes(dataStream -> {
            dataStream.writeUTF("ConnectOther");
            dataStream.writeUTF(playerName);
            dataStream.writeUTF(server);
        }));
    }

    public static void sendMessage(Plugin plugin, PluginMessageRecipient recipient, String player, String message) {
        BungeeUtils.sendPluginMessage(plugin, recipient, BungeeUtils.getDataBytes(dataStream -> {
            dataStream.writeUTF("Message");
            dataStream.writeUTF(player);
            dataStream.writeUTF(message);
        }));
    }

    public static void sendRawMessage(Plugin plugin, PluginMessageRecipient recipient, String player, String message) {
        BungeeUtils.sendPluginMessage(plugin, recipient, BungeeUtils.getDataBytes(dataStream -> {
            dataStream.writeUTF("MessageRaw");
            dataStream.writeUTF(player);
            dataStream.writeUTF(message);
        }));
    }

    public static void forward(Plugin plugin, PluginMessageRecipient recipient, String server, String channel, byte[] data) {
        BungeeUtils.sendPluginMessage(plugin, recipient, BungeeUtils.getDataBytes(dataStream -> {
            dataStream.writeUTF("Forward");
            dataStream.writeUTF(server);
            dataStream.writeUTF(channel);
            dataStream.writeShort(data.length);
            dataStream.write(data);
        }));
    }

    public static void forwardToPlayer(Plugin plugin, PluginMessageRecipient recipient, String player, String channel, byte[] data) {
        BungeeUtils.sendPluginMessage(plugin, recipient, BungeeUtils.getDataBytes(dataStream -> {
            dataStream.writeUTF("ForwardToPlayer");
            dataStream.writeUTF(player);
            dataStream.writeUTF(channel);
            dataStream.writeShort(data.length);
            dataStream.write(data);
        }));
    }

    public static void kickPlayer(Plugin plugin, PluginMessageRecipient recipient, String player, String message) {
        BungeeUtils.sendPluginMessage(plugin, recipient, BungeeUtils.getDataBytes(dataStream -> {
            dataStream.writeUTF("KickPlayer");
            dataStream.writeUTF(player);
            dataStream.writeUTF(message);
        }));
    }

    public static interface DataOutputConsumer {
        public void accept(DataOutputStream var1) throws IOException;
    }
}

