/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.bukkit.channel;

import me.hsgamer.hscore.bukkit.channel.BungeeUtils;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.bukkit.plugin.messaging.PluginMessageRecipient;

public abstract class Channel
implements PluginMessageListener {
    private final String name;
    private final Plugin plugin;

    protected Channel(String name, Plugin plugin) {
        this.name = name;
        this.plugin = plugin;
    }

    public void register() {
        this.plugin.getServer().getMessenger().registerIncomingPluginChannel(this.plugin, this.name, (PluginMessageListener)this);
        BungeeUtils.register(this.plugin, this.name);
    }

    public void unregister() {
        this.plugin.getServer().getMessenger().unregisterIncomingPluginChannel(this.plugin, this.name, (PluginMessageListener)this);
        BungeeUtils.unregister(this.plugin, this.name);
    }

    public abstract void handleMessage(Player var1, byte[] var2);

    public void send(byte[] data) {
        this.send(BungeeUtils.getGlobalRecipient(), data);
    }

    public void send(PluginMessageRecipient recipient, byte[] data) {
        BungeeUtils.sendPluginMessage(this.plugin, recipient, this.name, data);
    }

    public void onPluginMessageReceived(String channel, Player player, byte[] data) {
        if (channel.equalsIgnoreCase(this.name)) {
            this.handleMessage(player, data);
        }
    }

    public String getName() {
        return this.name;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }
}

