/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.bukkit.channel;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import me.hsgamer.hscore.bukkit.channel.BungeeUtils;
import me.hsgamer.hscore.bukkit.channel.Channel;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.PluginMessageRecipient;

public abstract class BungeeSubChannel
extends Channel {
    protected final Logger logger = Logger.getLogger(this.getClass().getSimpleName());
    private final String subChannel;

    protected BungeeSubChannel(String subChannel, Plugin plugin) {
        super("BungeeCord", plugin);
        this.subChannel = subChannel;
    }

    public String getSubChannel() {
        return this.subChannel;
    }

    public void sendForward(PluginMessageRecipient recipient, String toServer, byte[] data) {
        BungeeUtils.forward(this.getPlugin(), recipient, toServer, this.subChannel, data);
    }

    public void sendForward(String toServer, byte[] data) {
        this.sendForward((PluginMessageRecipient)this.getPlugin().getServer(), toServer, data);
    }

    public abstract void handleSubChannelMessage(Player var1, byte[] var2);

    @Override
    public void handleMessage(Player player, byte[] data) {
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(data);
             DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);){
            String channel = dataInputStream.readUTF();
            if (this.subChannel.equals(channel)) {
                int length = dataInputStream.available();
                byte[] subData = new byte[length];
                dataInputStream.readFully(subData);
                this.handleSubChannelMessage(player, subData);
            }
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "There is an exception when reading data", e);
        }
    }

    @Override
    public void send(PluginMessageRecipient recipient, byte[] data) {
        BungeeUtils.sendPluginMessage(this.getPlugin(), recipient, BungeeUtils.getDataBytes(dataStream -> {
            dataStream.writeUTF(this.subChannel);
            dataStream.write(data);
        }));
    }
}

