/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.bukkit.command;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandBuilder {
    private final String name;
    private final List<String> aliases = new ArrayList<String>();
    private String description;
    private String usage;
    private CommandExecutor executor;
    private TabCompleter tabCompleter;
    private String permission;
    private String permissionMessage;
    private boolean playerOnly = false;
    private String playerMessage;

    private CommandBuilder(@NotNull String name) {
        this.name = name;
    }

    @NotNull
    public static CommandBuilder newCommand(@NotNull String name) {
        return new CommandBuilder(name);
    }

    @NotNull
    public Command build() {
        Command command = new Command(this.name){

            public boolean execute(CommandSender sender, String commandLabel, String[] args) {
                if (CommandBuilder.this.playerOnly && !(sender instanceof Player)) {
                    if (CommandBuilder.this.playerMessage != null) {
                        sender.sendMessage(CommandBuilder.this.playerMessage);
                    }
                    return false;
                }
                if (!this.testPermission(sender)) {
                    return false;
                }
                return CommandBuilder.this.executor.onCommand(sender, (Command)this, commandLabel, args);
            }

            public List<String> tabComplete(CommandSender sender, String alias, String[] args) {
                return CommandBuilder.this.tabCompleter != null ? CommandBuilder.this.tabCompleter.onTabComplete(sender, (Command)this, alias, args) : super.tabComplete(sender, alias, args);
            }
        };
        command.setAliases(this.aliases);
        command.setDescription(this.description);
        command.setUsage(this.usage);
        command.setPermission(this.permission);
        command.setPermissionMessage(this.permissionMessage);
        return command;
    }

    @NotNull
    public CommandBuilder setDescription(@Nullable String description) {
        this.description = description;
        return this;
    }

    @NotNull
    public CommandBuilder setUsage(@Nullable String usage) {
        this.usage = usage;
        return this;
    }

    @NotNull
    public CommandBuilder setExecutor(@NotNull CommandExecutor executor) {
        this.executor = executor;
        return this;
    }

    @NotNull
    public CommandBuilder setTabCompleter(@Nullable TabCompleter tabCompleter) {
        this.tabCompleter = tabCompleter;
        return this;
    }

    @NotNull
    public CommandBuilder setPermission(@Nullable String permission) {
        this.permission = permission;
        return this;
    }

    @NotNull
    public CommandBuilder setPermissionMessage(@Nullable String permissionMessage) {
        this.permissionMessage = permissionMessage;
        return this;
    }

    @NotNull
    public CommandBuilder setPlayerMessage(@Nullable String playerMessage) {
        this.playerMessage = playerMessage;
        return this;
    }

    @NotNull
    public CommandBuilder setPlayerOnly() {
        this.playerOnly = true;
        return this;
    }
}

