/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.bukkit.command;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class CommandManager {
    private static final Supplier<CommandMap> COMMAND_MAP_SUPPLIER;
    private static final Supplier<Map<?, ?>> KNOWN_COMMANDS_SUPPLIER;
    private static final Runnable SYNC_COMMANDS_RUNNABLE;
    protected final JavaPlugin plugin;
    private final Map<String, Command> registered = new HashMap<String, Command>();

    public CommandManager(@NotNull JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public static void syncCommand() {
        SYNC_COMMANDS_RUNNABLE.run();
    }

    public static void unregisterFromKnownCommands(@NotNull Command command) {
        Map<?, ?> knownCommands = KNOWN_COMMANDS_SUPPLIER.get();
        knownCommands.values().removeIf(command::equals);
        command.unregister(COMMAND_MAP_SUPPLIER.get());
    }

    public static void registerCommandToCommandMap(@NotNull String label, @NotNull Command command) {
        COMMAND_MAP_SUPPLIER.get().register(label, command);
    }

    public final void register(@NotNull Command command) {
        String name = command.getLabel();
        if (this.registered.containsKey(name)) {
            this.plugin.getLogger().log(Level.WARNING, "Duplicated \"{0}\" command ! Ignored", name);
            return;
        }
        CommandManager.registerCommandToCommandMap(this.plugin.getName(), command);
        this.registered.put(name, command);
    }

    public final void unregister(@NotNull Command command) {
        CommandManager.unregisterFromKnownCommands(command);
        this.registered.remove(command.getLabel());
    }

    public final void unregister(@NotNull String command) {
        if (this.registered.containsKey(command)) {
            this.unregister(this.registered.remove(command));
        }
    }

    public final void unregisterAll() {
        this.registered.values().forEach(CommandManager::unregisterFromKnownCommands);
        this.registered.clear();
    }

    @NotNull
    public final Map<String, Command> getRegistered() {
        return Collections.unmodifiableMap(this.registered);
    }

    static {
        Runnable syncCommandsRunnable;
        Supplier<Map> knownCommandsSupplier;
        Method commandMapMethod;
        try {
            commandMapMethod = Bukkit.getServer().getClass().getMethod("getCommandMap", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new ExceptionInInitializerError(e);
        }
        COMMAND_MAP_SUPPLIER = () -> {
            try {
                return (CommandMap)commandMapMethod.invoke((Object)Bukkit.getServer(), new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new ExceptionInInitializerError(e);
            }
        };
        try {
            Method knownCommandsMethod = SimpleCommandMap.class.getDeclaredMethod("getKnownCommands", new Class[0]);
            knownCommandsSupplier = () -> {
                try {
                    return (Map)knownCommandsMethod.invoke((Object)COMMAND_MAP_SUPPLIER.get(), new Object[0]);
                }
                catch (ReflectiveOperationException e) {
                    throw new ExceptionInInitializerError(e);
                }
            };
        }
        catch (NoSuchMethodException e) {
            try {
                Field knownCommandsField = SimpleCommandMap.class.getDeclaredField("knownCommands");
                knownCommandsField.setAccessible(true);
                knownCommandsSupplier = () -> {
                    try {
                        return (Map)knownCommandsField.get(COMMAND_MAP_SUPPLIER.get());
                    }
                    catch (ReflectiveOperationException ex) {
                        throw new ExceptionInInitializerError(ex);
                    }
                };
            }
            catch (ReflectiveOperationException ex) {
                throw new ExceptionInInitializerError(ex);
            }
        }
        KNOWN_COMMANDS_SUPPLIER = knownCommandsSupplier;
        try {
            Class<?> craftServer = Bukkit.getServer().getClass();
            Method syncCommandsMethod = craftServer.getDeclaredMethod("syncCommands", new Class[0]);
            syncCommandsMethod.setAccessible(true);
            syncCommandsRunnable = () -> {
                try {
                    syncCommandsMethod.invoke((Object)Bukkit.getServer(), new Object[0]);
                }
                catch (ReflectiveOperationException e) {
                    Bukkit.getLogger().log(Level.WARNING, "Error when syncing commands", e);
                }
            };
        }
        catch (Exception e) {
            syncCommandsRunnable = () -> {};
        }
        SYNC_COMMANDS_RUNNABLE = syncCommandsRunnable;
    }
}

