/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.bukkit.config.object;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PlayableSound {
    @NotNull
    private final Sound sound;
    private final Double volume;
    private final Double pitch;

    public PlayableSound(@NotNull Sound sound, @NotNull Double volume, @NotNull Double pitch) {
        this.sound = sound;
        this.volume = volume;
        this.pitch = pitch;
    }

    public PlayableSound(@NotNull Sound sound, @NotNull Double volume) {
        this(sound, volume, 1.0);
    }

    public PlayableSound(@NotNull Sound sound) {
        this(sound, 1.0);
    }

    @Nullable
    public static PlayableSound deserialize(@NotNull Map<String, Object> serialized) {
        Object sound = serialized.get("sound");
        Object volume = serialized.getOrDefault("volume", 1.0);
        Object pitch = serialized.getOrDefault("pitch", 1.0);
        if (sound instanceof String && volume instanceof Number && pitch instanceof Number) {
            try {
                return new PlayableSound(Sound.valueOf((String)((String)sound)), ((Number)volume).doubleValue(), ((Number)pitch).doubleValue());
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        return null;
    }

    public void play(Player ... players) {
        this.play(Arrays.asList(players));
    }

    public void play(@NotNull Iterable<Player> players) {
        players.forEach(player -> this.play(player.getLocation(), (Player)player));
    }

    public void play(@NotNull Location location, Player ... players) {
        this.play(location, Arrays.asList(players));
    }

    public void play(@NotNull Location location, @NotNull Iterable<Player> players) {
        players.forEach(player -> player.playSound(location, this.sound, this.volume.floatValue(), this.pitch.floatValue()));
    }

    @NotNull
    public Map<String, Object> serialize() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sound", this.sound.name());
        map.put("volume", this.volume);
        map.put("pitch", this.pitch);
        return map;
    }
}

