/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.bukkit.config;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import me.hsgamer.hscore.config.CommentType;
import me.hsgamer.hscore.config.Config;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class BukkitConfig
implements Config {
    private static boolean isCommentSupported;
    private final File file;
    private final YamlConfiguration configuration = new YamlConfiguration();

    public BukkitConfig(File file) {
        this.file = file;
    }

    public BukkitConfig(Plugin plugin, String filename) {
        this(new File(plugin.getDataFolder(), filename));
        try {
            plugin.saveResource(filename, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public BukkitConfig(Plugin plugin) {
        this(plugin, "config.yml");
    }

    public YamlConfiguration getOriginal() {
        return this.configuration;
    }

    public Object get(String path, Object def) {
        return this.configuration.get(path, def);
    }

    public void set(String path, Object value) {
        this.configuration.set(path, value);
    }

    public boolean contains(String path) {
        return this.configuration.isSet(path);
    }

    public String getName() {
        return this.file.getName();
    }

    public void addDefault(String path, Object value) {
        this.configuration.addDefault(path, value);
    }

    public Map<String, Object> getValues(String path, boolean deep) {
        if (path == null || path.isEmpty()) {
            return this.configuration.getValues(deep);
        }
        return Optional.ofNullable(this.configuration.getConfigurationSection(path)).map(configurationSection -> configurationSection.getValues(deep)).orElse(Collections.emptyMap());
    }

    public Object normalize(Object object) {
        if (object instanceof ConfigurationSection) {
            return ((ConfigurationSection)object).getValues(false);
        }
        return object;
    }

    public boolean isNormalizable(Object object) {
        return object instanceof ConfigurationSection;
    }

    public void setup() {
        if (!this.file.exists()) {
            File parentFile = this.file.getAbsoluteFile().getParentFile();
            if (parentFile != null && !parentFile.exists()) {
                parentFile.mkdirs();
            }
            try {
                this.file.createNewFile();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, e, () -> "Something wrong when creating " + this.file.getName());
            }
        }
        this.configuration.options().copyDefaults(true);
        try {
            this.configuration.load(this.file);
        }
        catch (IOException | InvalidConfigurationException e) {
            LOGGER.log(Level.WARNING, e, () -> "Something wrong when loading " + this.file.getName());
        }
    }

    public void save() {
        try {
            this.configuration.save(this.file);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, e, () -> "Something wrong when saving " + this.file.getName());
        }
    }

    public void reload() {
        ArrayList keys = new ArrayList(this.configuration.getKeys(false));
        keys.forEach(key -> this.configuration.set(key, null));
        this.setup();
    }

    public String getComment(String path, CommentType type) {
        List comments;
        if (!isCommentSupported) {
            return null;
        }
        switch (type) {
            case BLOCK: {
                comments = this.configuration.getComments(path);
                break;
            }
            case SIDE: {
                comments = this.configuration.getInlineComments(path);
                break;
            }
            default: {
                comments = Collections.emptyList();
            }
        }
        return comments.isEmpty() ? null : String.join((CharSequence)"\n", comments);
    }

    public void setComment(String path, String value, CommentType type) {
        if (!isCommentSupported) {
            return;
        }
        List<String> comments = value == null ? null : Arrays.asList(value.split("\n"));
        switch (type) {
            case BLOCK: {
                this.configuration.setComments(path, comments);
                break;
            }
            case SIDE: {
                this.configuration.setInlineComments(path, comments);
                break;
            }
        }
    }

    static {
        try {
            isCommentSupported = ConfigurationSection.class.getDeclaredMethod("getComments", String.class) != null;
        }
        catch (NoSuchMethodException e) {
            isCommentSupported = false;
        }
    }
}

