/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.bukkit.config;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import me.hsgamer.hscore.config.CommentType;
import me.hsgamer.hscore.config.Config;
import me.hsgamer.hscore.config.PathString;
import me.hsgamer.hscore.logger.common.LogLevel;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class BukkitConfig
implements Config {
    private static boolean isCommentSupported;
    private final File file;
    private final YamlConfiguration configuration = new YamlConfiguration();

    public BukkitConfig(File file) {
        this.file = file;
    }

    public BukkitConfig(Plugin plugin, String filename) {
        this(new File(plugin.getDataFolder(), filename));
        try {
            plugin.saveResource(filename, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public BukkitConfig(Plugin plugin) {
        this(plugin, "config.yml");
    }

    private String toPath(PathString pathString) {
        return PathString.toPath((String)String.valueOf(this.configuration.options().pathSeparator()), (PathString)pathString);
    }

    private Map<PathString, Object> toPathStringMap(Map<String, Object> map) {
        return PathString.toPathStringMap((String)String.valueOf(this.configuration.options().pathSeparator()), map);
    }

    public YamlConfiguration getOriginal() {
        return this.configuration;
    }

    public Object get(PathString path, Object def) {
        return this.configuration.get(this.toPath(path), def);
    }

    public void set(PathString path, Object value) {
        this.configuration.set(this.toPath(path), value);
    }

    public boolean contains(PathString path) {
        return this.configuration.isSet(this.toPath(path));
    }

    public String getName() {
        return this.file.getName();
    }

    public void addDefault(PathString path, Object value) {
        this.configuration.addDefault(this.toPath(path), value);
    }

    public Map<PathString, Object> getValues(PathString path, boolean deep) {
        if (path.isRoot()) {
            return this.toPathStringMap(this.configuration.getValues(deep));
        }
        return Optional.ofNullable(this.configuration.getConfigurationSection(this.toPath(path))).map(configurationSection -> configurationSection.getValues(deep)).map(this::toPathStringMap).orElse(Collections.emptyMap());
    }

    public Object normalize(Object object) {
        if (object instanceof ConfigurationSection) {
            return ((ConfigurationSection)object).getValues(false);
        }
        return object;
    }

    public boolean isNormalizable(Object object) {
        return object instanceof ConfigurationSection;
    }

    public void setup() {
        if (!this.file.exists()) {
            File parentFile = this.file.getAbsoluteFile().getParentFile();
            if (parentFile != null && !parentFile.exists()) {
                parentFile.mkdirs();
            }
            try {
                this.file.createNewFile();
            }
            catch (IOException e) {
                LOGGER.log(LogLevel.WARN, "Something wrong when creating " + this.file.getName(), (Throwable)e);
            }
        }
        this.configuration.options().copyDefaults(true);
        try {
            this.configuration.load(this.file);
        }
        catch (IOException | InvalidConfigurationException e) {
            LOGGER.log(LogLevel.WARN, "Something wrong when loading " + this.file.getName(), e);
        }
    }

    public void save() {
        try {
            this.configuration.save(this.file);
        }
        catch (IOException e) {
            LOGGER.log(LogLevel.WARN, "Something wrong when saving " + this.file.getName(), (Throwable)e);
        }
    }

    public void reload() {
        ArrayList keys = new ArrayList(this.configuration.getKeys(false));
        keys.forEach(key -> this.configuration.set(key, null));
        this.setup();
    }

    public List<String> getComment(PathString path, CommentType type) {
        List comments;
        if (path.isRoot()) {
            String header = this.configuration.options().header();
            return header.isEmpty() ? null : Arrays.asList(header.split("\\r?\\n"));
        }
        if (!isCommentSupported) {
            return null;
        }
        switch (type) {
            case BLOCK: {
                comments = this.configuration.getComments(this.toPath(path));
                break;
            }
            case SIDE: {
                comments = this.configuration.getInlineComments(this.toPath(path));
                break;
            }
            default: {
                comments = Collections.emptyList();
            }
        }
        return comments.isEmpty() ? null : comments;
    }

    public void setComment(PathString path, List<String> value, CommentType type) {
        if (path.isRoot()) {
            this.configuration.options().copyHeader(true).header(value == null || value.isEmpty() ? null : String.join((CharSequence)System.lineSeparator(), value));
            return;
        }
        if (!isCommentSupported) {
            return;
        }
        switch (type) {
            case BLOCK: {
                this.configuration.setComments(this.toPath(path), value);
                break;
            }
            case SIDE: {
                this.configuration.setInlineComments(this.toPath(path), value);
                break;
            }
        }
    }

    static {
        try {
            isCommentSupported = ConfigurationSection.class.getDeclaredMethod("getComments", String.class) != null;
        }
        catch (NoSuchMethodException e) {
            isCommentSupported = false;
        }
    }
}

