/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.bukkit.gui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import me.hsgamer.hscore.bukkit.gui.GUIDisplay;
import me.hsgamer.hscore.bukkit.gui.button.ButtonMap;
import me.hsgamer.hscore.ui.BaseHolder;
import org.bukkit.Bukkit;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.plugin.Plugin;

public class GUIHolder
extends BaseHolder<GUIDisplay> {
    private final Plugin plugin;
    private boolean removeDisplayOnClose = true;
    private InventoryType inventoryType = InventoryType.CHEST;
    private Function<UUID, String> titleFunction = uuid -> this.inventoryType.getDefaultTitle();
    private ToIntFunction<UUID> sizeFunction = uuid -> InventoryType.CHEST.getDefaultSize();
    private Predicate<UUID> closeFilter = uuid -> true;
    private ButtonMap buttonMap = uuid -> Collections.emptyMap();

    public GUIHolder(Plugin plugin) {
        this.plugin = plugin;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public boolean isRemoveDisplayOnClose() {
        return this.removeDisplayOnClose;
    }

    public void setRemoveDisplayOnClose(boolean removeDisplayOnClose) {
        this.removeDisplayOnClose = removeDisplayOnClose;
    }

    public InventoryType getInventoryType() {
        return this.inventoryType;
    }

    public void setInventoryType(InventoryType inventoryType) {
        this.inventoryType = inventoryType;
    }

    public Function<UUID, String> getTitleFunction() {
        return this.titleFunction;
    }

    public void setTitleFunction(Function<UUID, String> titleFunction) {
        this.titleFunction = titleFunction;
    }

    public String getTitle(UUID uuid) {
        return this.titleFunction.apply(uuid);
    }

    public void setTitle(String title) {
        this.setTitleFunction(uuid -> title);
    }

    public ToIntFunction<UUID> getSizeFunction() {
        return this.sizeFunction;
    }

    public void setSizeFunction(ToIntFunction<UUID> sizeFunction) {
        this.sizeFunction = sizeFunction;
    }

    public int getSize(UUID uuid) {
        return this.sizeFunction.applyAsInt(uuid);
    }

    public void setSize(int size) {
        this.setSizeFunction(uuid -> size);
    }

    public Predicate<UUID> getCloseFilter() {
        return this.closeFilter;
    }

    public void setCloseFilter(Predicate<UUID> closeFilter) {
        this.closeFilter = closeFilter;
    }

    public ButtonMap getButtonMap() {
        return this.buttonMap;
    }

    public void setButtonMap(ButtonMap buttonMap) {
        this.buttonMap = buttonMap;
    }

    protected GUIDisplay newDisplay(UUID uuid) {
        return new GUIDisplay(uuid, this);
    }

    private Optional<GUIDisplay> getOpenDisplay(HumanEntity player) {
        return Optional.ofNullable(player.getOpenInventory()).map(InventoryView::getTopInventory).map(Inventory::getHolder).filter(GUIDisplay.class::isInstance).map(GUIDisplay.class::cast);
    }

    public void init() {
        this.addEventConsumer(InventoryCloseEvent.class, event -> {
            HumanEntity player = event.getPlayer();
            UUID uuid = player.getUniqueId();
            Optional<GUIDisplay> optionalDisplay = this.getOpenDisplay(player);
            if (!optionalDisplay.isPresent()) {
                return;
            }
            GUIDisplay display = optionalDisplay.get();
            if (!this.closeFilter.test(uuid)) {
                Bukkit.getScheduler().runTask(this.plugin, () -> player.openInventory(display.getInventory()));
            } else if (this.removeDisplayOnClose && display.getUniqueId() == uuid) {
                this.onOwnerRemoveDisplay(uuid, display, (InventoryCloseEvent)event);
                display.getInventory().getViewers().stream().filter(viewer -> viewer.getUniqueId() != uuid).forEach(HumanEntity::closeInventory);
                this.removeDisplay(uuid);
            }
        });
        this.addEventConsumer(InventoryOpenEvent.class, this::onOpen);
        this.addEventConsumer(InventoryClickEvent.class, this::onClick);
        this.addEventConsumer(InventoryCloseEvent.class, this::onClose);
        this.addEventConsumer(InventoryDragEvent.class, this::onDrag);
        this.addEventConsumer(InventoryClickEvent.class, event -> {
            HumanEntity player = event.getWhoClicked();
            UUID uuid = player.getUniqueId();
            this.getOpenDisplay(player).ifPresent(guiDisplay -> guiDisplay.handleClickEvent(uuid, (InventoryClickEvent)event));
        });
        this.buttonMap.init();
    }

    public void stop() {
        ArrayList list = new ArrayList(this.displayMap.values());
        super.stop();
        list.forEach(guiDisplay -> new ArrayList<HumanEntity>(guiDisplay.getInventory().getViewers()).forEach(HumanEntity::closeInventory));
        this.buttonMap.stop();
    }

    protected void onOpen(InventoryOpenEvent event) {
    }

    protected void onClick(InventoryClickEvent event) {
    }

    protected void onClose(InventoryCloseEvent event) {
    }

    protected void onOwnerRemoveDisplay(UUID uuid, GUIDisplay display, InventoryCloseEvent event) {
    }

    protected void onDrag(InventoryDragEvent event) {
    }
}

