/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.bukkit.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.IntStream;
import me.hsgamer.hscore.bukkit.gui.GUIHolder;
import me.hsgamer.hscore.bukkit.gui.button.Button;
import me.hsgamer.hscore.ui.BaseDisplay;
import me.hsgamer.hscore.ui.Holder;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class GUIDisplay
extends BaseDisplay<GUIHolder>
implements InventoryHolder {
    private final Map<Integer, Button> viewedButtons = new ConcurrentHashMap<Integer, Button>();
    private Inventory inventory;
    private boolean forceUpdate = false;

    public GUIDisplay(UUID uuid, GUIHolder holder) {
        super(uuid, (Holder)holder);
    }

    public boolean isForceUpdate() {
        return this.forceUpdate;
    }

    public GUIDisplay setForceUpdate(boolean forceUpdate) {
        this.forceUpdate = forceUpdate;
        return this;
    }

    public void handleClickEvent(UUID uuid, InventoryClickEvent event) {
        Optional.ofNullable(this.viewedButtons.get(event.getRawSlot())).ifPresent(button -> button.handleAction(uuid, event));
    }

    public void open(Player player) {
        player.openInventory(this.inventory);
    }

    public void open() {
        Player player = Bukkit.getPlayer((UUID)this.uuid);
        if (player != null) {
            this.open(player);
        }
    }

    public void init() {
        this.inventory = ((GUIHolder)this.holder).getInventoryFunction().apply(this, this.uuid);
        this.update();
    }

    public void stop() {
        if (this.inventory != null) {
            this.inventory.clear();
        }
        this.viewedButtons.clear();
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public void update() {
        if (this.inventory == null) {
            return;
        }
        int size = this.inventory.getSize();
        List emptyItemSlots = IntStream.range(0, size).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
        List emptyActionSlots = IntStream.range(0, size).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
        Map<Button, List<Integer>> buttonSlots = ((GUIHolder)this.holder).getButtonMap().getButtons(this.uuid);
        buttonSlots.forEach((button, slots) -> {
            ItemStack itemStack = button.getItemStack(this.uuid);
            if (itemStack == null && !button.forceSetAction(this.uuid)) {
                return;
            }
            slots.forEach(slot -> {
                if (slot >= size) {
                    return;
                }
                if (itemStack != null) {
                    this.inventory.setItem(slot.intValue(), itemStack);
                    emptyItemSlots.remove(slot);
                }
                this.viewedButtons.put((Integer)slot, (Button)button);
                emptyActionSlots.remove(slot);
            });
        });
        Button defaultButton = ((GUIHolder)this.holder).getButtonMap().getDefaultButton(this.uuid);
        ItemStack itemStack = defaultButton.getItemStack(this.uuid);
        emptyItemSlots.forEach(slot -> this.inventory.setItem(slot.intValue(), itemStack));
        emptyActionSlots.forEach(slot -> this.viewedButtons.put((Integer)slot, defaultButton));
        if (this.forceUpdate) {
            new ArrayList(this.inventory.getViewers()).stream().filter(Player.class::isInstance).forEach(humanEntity -> ((Player)humanEntity).updateInventory());
        }
    }
}

