/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.bukkit.gui;

import java.util.Iterator;
import me.hsgamer.hscore.bukkit.gui.GUIHolder;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;

public final class GUIUtils {
    private GUIUtils() {
    }

    public static void allowMoveItemOnBottom(GUIHolder holder) {
        holder.addEventConsumer(InventoryClickEvent.class, event -> {
            if (event.getClickedInventory() == event.getInventory()) {
                return;
            }
            switch (event.getAction()) {
                case DROP_ALL_SLOT: 
                case DROP_ONE_SLOT: 
                case PICKUP_ALL: 
                case PICKUP_HALF: 
                case PICKUP_ONE: 
                case PICKUP_SOME: 
                case HOTBAR_MOVE_AND_READD: 
                case PLACE_ALL: 
                case PLACE_ONE: 
                case PLACE_SOME: 
                case HOTBAR_SWAP: 
                case SWAP_WITH_CURSOR: {
                    event.setCancelled(false);
                    break;
                }
            }
        });
    }

    public static void cancelDragEvent(GUIHolder holder) {
        holder.addEventConsumer(InventoryDragEvent.class, event -> {
            Iterator iterator = event.getRawSlots().iterator();
            while (iterator.hasNext()) {
                int slot = (Integer)iterator.next();
                if (slot >= event.getInventory().getSize()) continue;
                event.setCancelled(true);
                break;
            }
        });
    }

    public static int normalizeToChestSize(int size) {
        int remain = size % 9;
        size -= remain;
        return size += remain > 0 ? 9 : 0;
    }
}

