/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.bukkit.gui;

import java.util.ArrayList;
import java.util.UUID;
import me.hsgamer.hscore.bukkit.gui.BukkitGUIHolder;
import me.hsgamer.hscore.bukkit.gui.object.BukkitItem;
import me.hsgamer.hscore.minecraft.gui.GUIHolder;
import me.hsgamer.hscore.minecraft.gui.InventoryGUIDisplay;
import me.hsgamer.hscore.minecraft.gui.event.CloseEvent;
import me.hsgamer.hscore.minecraft.gui.object.Item;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

public class BukkitGUIDisplay
extends InventoryGUIDisplay<BukkitGUIHolder>
implements InventoryHolder {
    private Inventory inventory;
    private boolean forceUpdate = false;

    public BukkitGUIDisplay(UUID uuid, BukkitGUIHolder holder) {
        super(uuid, (GUIHolder)holder);
    }

    public boolean isForceUpdate() {
        return this.forceUpdate;
    }

    public BukkitGUIDisplay setForceUpdate(boolean forceUpdate) {
        this.forceUpdate = forceUpdate;
        return this;
    }

    protected void initInventory() {
        this.inventory = ((BukkitGUIHolder)this.holder).getInventoryFunction().apply(this, this.uuid);
    }

    protected void clearInventory() {
        if (this.inventory != null) {
            this.inventory.clear();
        }
    }

    protected int getInventorySize() {
        return this.inventory != null ? this.inventory.getSize() : 0;
    }

    protected void setButton(int slot, @Nullable Item item) {
        if (item == null) {
            this.inventory.setItem(slot, new ItemStack(Material.AIR));
        } else if (item instanceof BukkitItem) {
            this.inventory.setItem(slot, ((BukkitItem)item).getItemStack());
        }
    }

    public void scheduleReopen(CloseEvent event) {
        Player player = Bukkit.getPlayer((UUID)this.uuid);
        if (player != null) {
            Bukkit.getScheduler().runTask(((BukkitGUIHolder)this.holder).getPlugin(), () -> player.openInventory(this.inventory));
        }
    }

    public void open() {
        Player player = Bukkit.getPlayer((UUID)this.uuid);
        if (player != null) {
            player.openInventory(this.inventory);
        }
    }

    public void init() {
        this.inventory = ((BukkitGUIHolder)this.holder).getInventoryFunction().apply(this, this.uuid);
        this.update();
    }

    public void stop() {
        if (this.inventory != null) {
            this.inventory.clear();
        }
        this.viewedButtons.clear();
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public void update() {
        super.update();
        if (this.forceUpdate) {
            new ArrayList(this.inventory.getViewers()).stream().filter(Player.class::isInstance).forEach(humanEntity -> ((Player)humanEntity).updateInventory());
        }
    }
}

